/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.classloader;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.net.URI;
import org.fabric3.spi.classloader.ClassLoaderRegistry;

public class MultiClassLoaderObjectInputStream
extends ObjectInputStream {
    private ClassLoaderRegistry registry;

    public MultiClassLoaderObjectInputStream(InputStream in, ClassLoaderRegistry registry) throws IOException {
        super(in);
        this.registry = registry;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
        byte val = this.readByte();
        if (val == -1) {
            return super.resolveClass(desc);
        }
        byte[] bytes = new byte[val];
        int result = this.read(bytes);
        if (result == -1) {
            throw new IOException("Invalid classloader URL");
        }
        String id = new String(bytes);
        URI uri = URI.create(id);
        ClassLoader cl = this.registry.getClassLoader(uri);
        if (cl == null) {
            throw new IOException("Contribution not installed: " + id);
        }
        return Class.forName(desc.getName(), false, cl);
    }
}

