/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.channel.impl;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.channel.impl.FanOutHandler;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.container.channel.EventStreamHandler;
import org.fabric3.spi.container.channel.PassThroughHandler;
import org.fabric3.spi.model.physical.ChannelSide;

public class DefaultChannelImpl
implements Channel {
    private URI uri;
    private QName deployable;
    private final ChannelSide channelSide;
    private EventStreamHandler headHandler;
    private EventStreamHandler tailHandler;
    private EventStreamHandler inHandler;
    private FanOutHandler fanOutHandler;

    public DefaultChannelImpl(URI uri, QName deployable, FanOutHandler fanOutHandler, ChannelSide channelSide) {
        this.uri = uri;
        this.deployable = deployable;
        this.channelSide = channelSide;
        this.inHandler = new PassThroughHandler();
        this.fanOutHandler = fanOutHandler;
        this.inHandler.setNext((EventStreamHandler)this.fanOutHandler);
    }

    public DefaultChannelImpl(URI uri, QName deployable, EventStreamHandler inHandler, FanOutHandler fanOutHandler, ChannelSide channelSide) {
        this.uri = uri;
        this.deployable = deployable;
        this.inHandler = inHandler;
        this.fanOutHandler = fanOutHandler;
        this.channelSide = channelSide;
        this.inHandler.setNext((EventStreamHandler)fanOutHandler);
    }

    public URI getUri() {
        return this.uri;
    }

    public QName getDeployable() {
        return this.deployable;
    }

    public void start() {
    }

    public void stop() {
    }

    public void addHandler(EventStreamHandler handler) {
        if (this.headHandler == null) {
            this.headHandler = handler;
            this.inHandler.setNext(handler);
        } else {
            this.tailHandler.setNext(handler);
        }
        this.tailHandler = handler;
        this.tailHandler.setNext((EventStreamHandler)this.fanOutHandler);
    }

    public void removeHandler(EventStreamHandler handler) {
        EventStreamHandler previous = null;
        for (EventStreamHandler current = this.headHandler; current != null; current = current.getNext()) {
            if (current == handler) {
                if (this.headHandler == current) {
                    this.headHandler = current.getNext();
                }
                if (this.tailHandler == current) {
                    EventStreamHandler eventStreamHandler = this.tailHandler = previous == null ? this.headHandler : previous;
                }
                if (previous != null) {
                    previous.setNext(current.getNext());
                }
                this.inHandler.setNext(this.headHandler);
                return;
            }
            previous = current;
        }
    }

    public void attach(EventStreamHandler handler) {
        handler.setNext(this.inHandler);
    }

    public void attach(ChannelConnection connection) {
        EventStream stream = connection.getEventStream();
        stream.getTailHandler().setNext(this.inHandler);
    }

    public void subscribe(URI uri, ChannelConnection connection) {
        this.fanOutHandler.addConnection(uri, connection);
    }

    public ChannelConnection unsubscribe(URI uri) {
        return this.fanOutHandler.removeConnection(uri);
    }

    public ChannelSide getChannelSide() {
        return this.channelSide;
    }
}

