/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.channel.impl;

import java.util.concurrent.ExecutorService;
import org.fabric3.channel.impl.AbstractFanOutHandler;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.EventStream;

public class AsyncFanOutHandler
extends AbstractFanOutHandler {
    private ExecutorService executorService;

    public AsyncFanOutHandler(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void handle(Object event, boolean endOfBatch) {
        if (this.connections.length == 0) {
            return;
        }
        FanOutWork work = new FanOutWork(event);
        this.executorService.execute(work);
    }

    private class FanOutWork
    implements Runnable {
        private Object event;

        private FanOutWork(Object event) {
            this.event = event;
        }

        @Override
        public void run() {
            for (ChannelConnection connection : AsyncFanOutHandler.this.connections) {
                EventStream stream = connection.getEventStream();
                stream.getHeadHandler().handle(this.event, true);
            }
        }
    }
}

