/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.channel.builder;

import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import org.fabric3.channel.impl.AbstractFanOutHandler;
import org.fabric3.channel.impl.AsyncFanOutHandler;
import org.fabric3.channel.impl.DefaultChannelImpl;
import org.fabric3.channel.impl.SyncFanOutHandler;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.channel.ChannelBuilder;
import org.fabric3.spi.container.builder.component.ChannelBindingBuilder;
import org.fabric3.spi.container.channel.Channel;
import org.fabric3.spi.model.physical.PhysicalChannelBindingDefinition;
import org.fabric3.spi.model.physical.PhysicalChannelDefinition;
import org.oasisopen.sca.annotation.Reference;

public class DefaultChannelBuilder
implements ChannelBuilder {
    private ExecutorService executorService;
    private Map<Class<? extends PhysicalChannelBindingDefinition>, ChannelBindingBuilder> bindingBuilders = Collections.emptyMap();

    public DefaultChannelBuilder(@Reference(name="executorService") ExecutorService executorService) {
        this.executorService = executorService;
    }

    @Reference(required=false)
    public void setBindingBuilders(Map<Class<? extends PhysicalChannelBindingDefinition>, ChannelBindingBuilder> builders) {
        this.bindingBuilders = builders;
    }

    public Channel build(PhysicalChannelDefinition definition) throws ContainerException {
        URI uri = definition.getUri();
        QName deployable = definition.getDeployable();
        AbstractFanOutHandler fanOutHandler = definition.getBindingDefinition() != null ? new SyncFanOutHandler() : new AsyncFanOutHandler(this.executorService);
        DefaultChannelImpl channel = new DefaultChannelImpl(uri, deployable, fanOutHandler, definition.getChannelSide());
        PhysicalChannelBindingDefinition bindingDefinition = definition.getBindingDefinition();
        this.buildBinding(channel, bindingDefinition);
        return channel;
    }

    public void dispose(PhysicalChannelDefinition definition, Channel channel) throws ContainerException {
        this.disposeBinding(channel, definition.getBindingDefinition());
    }

    private void buildBinding(Channel channel, PhysicalChannelBindingDefinition bindingDefinition) throws ContainerException {
        if (bindingDefinition != null) {
            ChannelBindingBuilder builder = this.getBuilder(bindingDefinition);
            builder.build(bindingDefinition, channel);
        }
    }

    private void disposeBinding(Channel channel, PhysicalChannelBindingDefinition bindingDefinition) throws ContainerException {
        if (bindingDefinition != null) {
            ChannelBindingBuilder builder = this.getBuilder(bindingDefinition);
            builder.dispose(bindingDefinition, channel);
        }
    }

    private ChannelBindingBuilder getBuilder(PhysicalChannelBindingDefinition definition) throws ContainerException {
        ChannelBindingBuilder builder = this.bindingBuilders.get(definition.getClass());
        if (builder == null) {
            throw new ContainerException("Channel binding builder not found for type " + definition.getClass());
        }
        return builder;
    }
}

