/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jndi.runtime;

import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import org.fabric3.jndi.provision.PhysicalJndiContextDefinition;
import org.fabric3.jndi.spi.JndiContextManager;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.resource.ResourceBuilder;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class JndiContextBuilder
implements ResourceBuilder<PhysicalJndiContextDefinition> {
    private JndiContextManager manager;

    public JndiContextBuilder(@Reference JndiContextManager manager) {
        this.manager = manager;
    }

    public void build(PhysicalJndiContextDefinition definition) throws ContainerException {
        for (Map.Entry<String, Properties> entry : definition.getContexts().entrySet()) {
            try {
                this.manager.register(entry.getKey(), entry.getValue());
            }
            catch (NamingException e) {
                throw new ContainerException((Throwable)e);
            }
        }
    }

    public void remove(PhysicalJndiContextDefinition definition) throws ContainerException {
        for (String name : definition.getContexts().keySet()) {
            try {
                this.manager.unregister(name);
            }
            catch (NamingException e) {
                throw new ContainerException((Throwable)e);
            }
        }
    }
}

