/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.jndi.impl;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.jndi.impl.ContextManagerMonitor;
import org.fabric3.jndi.spi.JndiContextManager;
import org.oasisopen.sca.annotation.Destroy;

public class JndiContextManagerImpl
implements JndiContextManager {
    private Map<String, Context> contexts = new ConcurrentHashMap<String, Context>();
    private ContextManagerMonitor monitor;

    public JndiContextManagerImpl(@Monitor ContextManagerMonitor monitor) {
        this.monitor = monitor;
    }

    @Destroy
    public void destroy() {
        for (Context context : this.contexts.values()) {
            try {
                context.close();
            }
            catch (NamingException e) {
                this.monitor.closeError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(String name, Properties properties) throws NamingException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            InitialContext context = new InitialContext(properties);
            if (this.contexts.containsKey(name)) {
                throw new NamingException("Duplicate context: " + name);
            }
            this.contexts.put(name, context);
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    @Override
    public void unregister(String name) throws NamingException {
        Context context = this.contexts.remove(name);
        if (context != null) {
            context.close();
        }
    }

    @Override
    public Context get(String name) {
        return this.contexts.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lookup(Class<T> clazz, String name) throws NamingException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            for (Context context : this.contexts.values()) {
                T t;
                try {
                    Object bound = context.lookup(name);
                    if (bound == null) continue;
                    t = clazz.cast(bound);
                }
                catch (NameNotFoundException e) {
                    continue;
                }
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T lookup(Class<T> clazz, Name name) throws NamingException {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            for (Context context : this.contexts.values()) {
                T t;
                try {
                    Object bound = context.lookup(name);
                    if (bound == null) continue;
                    t = clazz.cast(bound);
                }
                catch (NameNotFoundException e) {
                    continue;
                }
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }
}

