/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.json.transform;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;

public class String2ObjectJsonTransformer
implements Transformer<String, Object> {
    private ObjectMapper mapper;
    private Class<?> type;

    public String2ObjectJsonTransformer(Class<?> type, ObjectMapper mapper) {
        this.type = type;
        this.mapper = mapper;
    }

    public Object transform(String source, ClassLoader loader) throws TransformationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            Object object = this.mapper.readValue(source, this.type);
            return object;
        }
        catch (IOException e) {
            throw new TransformationException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

