/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.databinding.json.transform;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;

public class Stream2ObjectJsonTransformer
implements Transformer<InputStream, Object> {
    private ObjectMapper mapper;
    private Class<?> type;

    public Stream2ObjectJsonTransformer(Class<?> type, ObjectMapper mapper) {
        this.type = type;
        this.mapper = mapper;
    }

    public Object transform(InputStream source, ClassLoader loader) throws TransformationException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loader);
            JsonParser jp = this.mapper.getFactory().createParser(source);
            jp.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
            Object object = this.mapper.readValue(jp, this.type);
            return object;
        }
        catch (IOException e) {
            throw new TransformationException((Throwable)e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }
}

