/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import org.fabric3.api.host.monitor.MonitorCreationException;
import org.fabric3.api.host.monitor.MonitorProxyService;
import org.fabric3.api.host.monitor.Monitorable;
import org.fabric3.monitor.provision.MonitorWireTargetDefinition;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetWireAttacher;
import org.fabric3.spi.container.component.Component;
import org.fabric3.spi.container.component.ComponentManager;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.objectfactory.SingletonObjectFactory;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalWireSourceDefinition;
import org.oasisopen.sca.annotation.Reference;

public class MonitorWireAttacher
implements TargetWireAttacher<MonitorWireTargetDefinition> {
    private final MonitorProxyService monitorService;
    private ComponentManager componentManager;
    private final ClassLoaderRegistry classLoaderRegistry;

    public MonitorWireAttacher(@Reference MonitorProxyService monitorService, @Reference ComponentManager componentManager, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.monitorService = monitorService;
        this.componentManager = componentManager;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalWireSourceDefinition source, MonitorWireTargetDefinition target, Wire wire) throws ContainerException {
        throw new UnsupportedOperationException();
    }

    public void detach(PhysicalWireSourceDefinition source, MonitorWireTargetDefinition target) throws ContainerException {
        throw new AssertionError();
    }

    public ObjectFactory<?> createObjectFactory(MonitorWireTargetDefinition target) throws ContainerException {
        try {
            ClassLoader loader = this.classLoaderRegistry.getClassLoader(target.getClassLoaderId());
            Class type = this.classLoaderRegistry.loadClass(loader, target.getMonitorType());
            Component monitorable = this.componentManager.getComponent(target.getMonitorable());
            Object monitor = this.monitorService.createMonitor(type, (Monitorable)monitorable, target.getDestination());
            return new SingletonObjectFactory(monitor);
        }
        catch (ClassNotFoundException e) {
            throw new ContainerException("Unable to load monitor class: " + target.getMonitorType(), (Throwable)e);
        }
        catch (MonitorCreationException e) {
            throw new ContainerException("Unable to create monitor for class: " + target.getMonitorType(), (Throwable)e);
        }
    }
}

