/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.proxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.fabric3.api.MonitorChannel;
import org.fabric3.api.host.monitor.DestinationRouter;
import org.fabric3.api.host.monitor.MonitorCreationException;
import org.fabric3.api.host.monitor.MonitorProxyServiceExtension;
import org.fabric3.api.host.monitor.Monitorable;
import org.fabric3.monitor.proxy.JDKMonitorHandler;
import org.fabric3.spi.monitor.DispatchInfo;
import org.fabric3.spi.monitor.MonitorProxy;
import org.fabric3.spi.monitor.MonitorUtil;

public class JDKMonitorProxyService
implements MonitorProxyServiceExtension {
    private Monitorable defaultMonitorable;
    private DestinationRouter router;

    public JDKMonitorProxyService(Monitorable monitorable, DestinationRouter router) {
        this.defaultMonitorable = monitorable;
        this.router = router;
    }

    public <T> T createMonitor(Class<T> type) throws MonitorCreationException {
        return this.createMonitor(type, this.defaultMonitorable, "default");
    }

    public <T> T createMonitor(Class<T> type, Monitorable monitorable, String destination) throws MonitorCreationException {
        if (destination == null) {
            destination = "default";
        }
        int destinationIndex = this.router.getDestinationIndex(destination);
        ClassLoader loader = type.getClassLoader();
        HashMap<Method, DispatchInfo> levels = new HashMap<Method, DispatchInfo>();
        for (Method method : type.getMethods()) {
            DispatchInfo info = this.createDispatchInfo(type, loader, method);
            levels.put(method, info);
        }
        JDKMonitorHandler handler = new JDKMonitorHandler(destinationIndex, monitorable, this.router, levels);
        if (MonitorChannel.class.isAssignableFrom(type) || MonitorProxy.class.isAssignableFrom(type)) {
            return type.cast(handler);
        }
        return type.cast(Proxy.newProxyInstance(loader, new Class[]{type}, (InvocationHandler)handler));
    }

    private <T> DispatchInfo createDispatchInfo(Class<T> type, ClassLoader loader, Method method) {
        DispatchInfo info = MonitorUtil.getDispatchInfo((Method)method);
        String message = info.getMessage();
        if (Locale.ENGLISH.getLanguage().equals(Locale.getDefault().getLanguage())) {
            if (message.length() > 0) {
                return info;
            }
            if (message.length() == 0) {
                Class<?>[] types = method.getParameterTypes();
                if (types.length == 1 && String.class.equals(types[0])) {
                    info.setMessage("{0}");
                    return info;
                }
                if (types.length == 2 && String.class.equals(types[0]) && Throwable.class.isAssignableFrom(types[1])) {
                    info.setMessage("{0}");
                    return info;
                }
            }
        }
        String key = type.getName() + "#" + method.getName();
        ResourceBundle bundle = this.locateBundle(type, "f3", loader);
        if (bundle != null) {
            try {
                message = bundle.getString(key);
            }
            catch (MissingResourceException e) {
                // empty catch block
            }
        }
        if (message.length() == 0 && method.getParameterTypes().length == 0) {
            message = key;
        }
        info.setMessage(message);
        return info;
    }

    private <T> ResourceBundle locateBundle(Class<T> monitorInterface, String bundleName, ClassLoader loader) {
        Locale locale = Locale.getDefault();
        String packageName = monitorInterface.getPackage().getName();
        while (true) {
            try {
                return ResourceBundle.getBundle(packageName + '.' + bundleName, locale, loader);
            }
            catch (MissingResourceException e) {
                int index = packageName.lastIndexOf(46);
                if (index != -1) {
                    packageName = packageName.substring(0, index);
                    continue;
                }
                try {
                    return ResourceBundle.getBundle(bundleName, locale, loader);
                }
                catch (Exception e2) {
                    return null;
                }
            }
            break;
        }
    }
}

