/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.introspection;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.binding.ws.model.EndpointReference;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.binding.ws.introspection.MissingAddress;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class WsaLoader
implements TypeLoader<EndpointReference> {
    private static final QName ENDPOINT_REFERENCE = new QName("http://www.w3.org/2005/08/addressing", "EndpointReference");
    private static final QName ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address");

    public EndpointReference load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        EndpointReference endpointReference = null;
        Location location = reader.getLocation();
        while (true) {
            switch (reader.next()) {
                case 1: {
                    if (!ADDRESS.equals(reader.getName())) break;
                    String addressStr = reader.getElementText();
                    try {
                        URI uri = new URI(addressStr);
                        return new EndpointReference(uri);
                    }
                    catch (URISyntaxException e) {
                        InvalidValue error = new InvalidValue("Invalid address", location, new ModelObject[0]);
                        context.addError((ValidationFailure)error);
                        return new EndpointReference(URI.create("http://errornoaddress"));
                    }
                }
                case 2: {
                    if (!ADDRESS.equals(reader.getName())) break;
                    if (endpointReference == null) {
                        MissingAddress error = new MissingAddress("Address not specified", location, new ModelObject[0]);
                        context.addError((ValidationFailure)error);
                        return new EndpointReference(URI.create("http://errornoaddress"));
                    }
                    return endpointReference;
                }
            }
        }
    }
}

