/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.introspection;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.fabric3.api.binding.ws.annotation.BindingConfiguration;
import org.fabric3.api.binding.ws.annotation.WebServiceBinding;
import org.fabric3.api.binding.ws.model.WsBindingDefinition;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.component.AbstractService;
import org.fabric3.api.model.type.component.BindingDefinition;
import org.fabric3.api.model.type.component.ReferenceDefinition;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.AbstractBindingPostProcessor;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.oasisopen.sca.annotation.EagerInit;

@EagerInit
public class WsBindingPostProcessor
extends AbstractBindingPostProcessor<WebServiceBinding> {
    public WsBindingPostProcessor() {
        super(WebServiceBinding.class);
    }

    protected BindingDefinition processService(WebServiceBinding annotation, AbstractService<?> service, InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        return this.createDefinition(annotation, implClass, context);
    }

    protected BindingDefinition processServiceCallback(WebServiceBinding annotation, AbstractService<?> service, InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        return null;
    }

    protected BindingDefinition processReference(WebServiceBinding annotation, ReferenceDefinition reference, AccessibleObject object, Class<?> implClass, IntrospectionContext context) {
        return this.createDefinition(annotation, implClass, context);
    }

    protected BindingDefinition processReferenceCallback(WebServiceBinding annotation, ReferenceDefinition reference, AccessibleObject object, Class<?> implClass, IntrospectionContext context) {
        return null;
    }

    private WsBindingDefinition createDefinition(WebServiceBinding annotation, Class<?> implClass, IntrospectionContext context) {
        String name = annotation.name();
        if (name.isEmpty()) {
            name = "WSBinding";
        }
        URI uri = this.parseUri(annotation, implClass, context);
        String wsdlLocation = this.getNullibleValue(annotation.wsdlLocation());
        String wsdlElement = this.getNullibleValue(annotation.wsdlElement());
        int retries = annotation.retries();
        WsBindingDefinition binding = new WsBindingDefinition(name, uri, wsdlLocation, wsdlElement, retries);
        this.parseConfiguration(annotation, binding);
        return binding;
    }

    private void parseConfiguration(WebServiceBinding annotation, WsBindingDefinition binding) {
        BindingConfiguration[] configurations = annotation.configuration();
        if (configurations.length == 0) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (BindingConfiguration configuration : configurations) {
            map.put(configuration.key(), configuration.value());
        }
        binding.setConfiguration(map);
    }

    private URI parseUri(WebServiceBinding annotation, Class<?> implClass, IntrospectionContext context) {
        String uriString = this.getNullibleValue(annotation.uri());
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            InvalidAnnotation error = new InvalidAnnotation("Invalid web service binding uri", implClass, (Annotation)annotation, implClass, (Exception)e);
            context.addError((ValidationFailure)error);
            return URI.create("errorUri");
        }
    }
}

