/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.ws.introspection;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.binding.ws.model.EndpointReference;
import org.fabric3.api.binding.ws.model.WsBindingDefinition;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.BindingHandlerDefinition;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderRegistry;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class WsBindingLoader
extends AbstractValidatingTypeLoader<WsBindingDefinition> {
    private static final String WSDL_NS = "http://www.w3.org/ns/wsdl-instance";
    private static final String WSDL_2004_NS = "http://www.w3.org/2004/08/wsdl-instance";
    private final LoaderHelper loaderHelper;
    private final LoaderRegistry registry;

    public WsBindingLoader(@Reference LoaderHelper loaderHelper, @Reference LoaderRegistry registry) {
        this.loaderHelper = loaderHelper;
        this.registry = registry;
        this.addAttributes(new String[]{"uri", "impl", "wsdlElement", "wsdlLocation", "requires", "policySets", "name", "retries"});
    }

    public WsBindingDefinition load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location location = reader.getLocation();
        String wsdlElement = reader.getAttributeValue(null, "wsdlElement");
        String wsdlLocation = reader.getAttributeValue(WSDL_NS, "wsdlLocation");
        if (wsdlLocation == null) {
            wsdlLocation = reader.getAttributeValue(WSDL_2004_NS, "wsdlLocation");
        }
        int retries = this.parseRetries(reader, context);
        String bindingName = reader.getAttributeValue(null, "name");
        URI targetUri = this.parseTargetUri(reader, context);
        WsBindingDefinition binding = new WsBindingDefinition(bindingName, targetUri, wsdlLocation, wsdlElement, retries);
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)binding, reader, context);
        this.validateAttributes(reader, context, new ModelObject[]{binding});
        if (wsdlLocation != null && wsdlElement == null) {
            MissingAttribute error = new MissingAttribute("A wsdlLocation was specified but not a wsdlElement", location, new ModelObject[]{binding});
            context.addError((ValidationFailure)error);
        }
        while (true) {
            switch (reader.next()) {
                case 1: {
                    Object elementValue = this.registry.load(reader, Object.class, context);
                    Location startAttribute = reader.getLocation();
                    if (elementValue instanceof BindingHandlerDefinition) {
                        binding.addHandler((BindingHandlerDefinition)elementValue);
                        break;
                    }
                    if (elementValue instanceof Map) {
                        binding.setConfiguration((Map)elementValue);
                        break;
                    }
                    if (!(elementValue instanceof EndpointReference)) break;
                    EndpointReference endpointReference = (EndpointReference)elementValue;
                    if (targetUri != null) {
                        InvalidValue error = new InvalidValue("Cannot specify both a target URI and endpoint reference on a web services binding", startAttribute, new ModelObject[]{binding});
                        context.addError((ValidationFailure)error);
                        break;
                    }
                    binding.setTargetUri(endpointReference.getAddress());
                    break;
                }
                case 2: {
                    String name = reader.getName().getLocalPart();
                    if (!"binding.ws".equals(name)) break;
                    return binding;
                }
                case 8: {
                    return binding;
                }
            }
        }
    }

    private URI parseTargetUri(XMLStreamReader reader, IntrospectionContext context) {
        String uri = reader.getAttributeValue(null, "uri");
        URI targetUri = null;
        if (uri != null) {
            try {
                targetUri = new URI(uri);
            }
            catch (URISyntaxException ex) {
                Location location = reader.getLocation();
                InvalidValue failure = new InvalidValue("The web services binding URI is not a valid: " + uri, location, new ModelObject[0]);
                context.addError((ValidationFailure)failure);
            }
        }
        return targetUri;
    }

    private int parseRetries(XMLStreamReader reader, IntrospectionContext context) {
        String retries = reader.getAttributeValue(null, "retries");
        if (retries != null) {
            try {
                return Integer.parseInt(retries);
            }
            catch (NumberFormatException e) {
                Location location = reader.getLocation();
                InvalidValue error = new InvalidValue("The retries attribute must be a valid number", location, new ModelObject[0]);
                context.addError((ValidationFailure)error);
            }
        }
        return 0;
    }
}

