/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.proxy.jdk.wire;

import java.lang.reflect.Method;
import java.util.Map;
import org.fabric3.implementation.proxy.jdk.wire.AbstractCallbackInvocationHandler;
import org.fabric3.spi.container.invocation.CallbackReference;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.container.wire.InvocationChain;

public class MultiThreadedCallbackInvocationHandler<T>
extends AbstractCallbackInvocationHandler<T> {
    private Map<String, Map<Method, InvocationChain>> mappings;
    private Map<Method, InvocationChain> singleMapping;

    public MultiThreadedCallbackInvocationHandler(Map<String, Map<Method, InvocationChain>> mappings) {
        this.mappings = mappings;
        if (mappings.size() == 1) {
            this.singleMapping = mappings.values().iterator().next();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        WorkContext workContext = WorkContextCache.getThreadWorkContext();
        CallbackReference callbackReference = workContext.peekCallbackReference();
        String callbackUri = callbackReference.getServiceUri();
        Map<Method, InvocationChain> chains = this.singleMapping != null ? this.singleMapping : this.mappings.get(callbackUri);
        InvocationChain chain = chains.get(method);
        if (chain == null) {
            return this.handleProxyMethod(method);
        }
        return super.invoke(chain, args, workContext);
    }
}

