/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.proxy.jdk.wire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.implementation.pojo.spi.proxy.ProxyCreationException;
import org.fabric3.implementation.proxy.jdk.wire.CallbackWireObjectFactory;
import org.fabric3.implementation.proxy.jdk.wire.JDKInvocationHandler;
import org.fabric3.implementation.proxy.jdk.wire.JDKWireProxyService;
import org.fabric3.implementation.proxy.jdk.wire.MultiThreadedCallbackInvocationHandler;
import org.fabric3.implementation.proxy.jdk.wire.NoMethodForOperationException;
import org.fabric3.implementation.proxy.jdk.wire.StatefulCallbackInvocationHandler;
import org.fabric3.implementation.proxy.jdk.wire.WireObjectFactory;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.Reference;

public class JDKWireProxyServiceImpl
implements JDKWireProxyService {
    private ClassLoaderRegistry classLoaderRegistry;

    public JDKWireProxyServiceImpl(@Reference ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public boolean isDefault() {
        return true;
    }

    public <T> ObjectFactory<T> createObjectFactory(Class<T> interfaze, Wire wire, String callbackUri) throws ProxyCreationException {
        Map<Method, InvocationChain> mappings = this.createInterfaceToWireMapping(interfaze, wire);
        return new WireObjectFactory<T>(interfaze, callbackUri, this, mappings);
    }

    public <T> ObjectFactory<T> createCallbackObjectFactory(Class<T> interfaze, boolean multiThreaded, URI callbackUri, Wire wire) throws ProxyCreationException {
        Map<Method, InvocationChain> operationMappings = this.createInterfaceToWireMapping(interfaze, wire);
        HashMap<String, Map<Method, InvocationChain>> mappings = new HashMap<String, Map<Method, InvocationChain>>();
        mappings.put(callbackUri.toString(), operationMappings);
        return new CallbackWireObjectFactory<T>(interfaze, multiThreaded, this, mappings);
    }

    public <T> ObjectFactory<?> updateCallbackObjectFactory(ObjectFactory<?> factory, Class<T> interfaze, boolean multiThreaded, URI callbackUri, Wire wire) throws ProxyCreationException {
        if (!(factory instanceof CallbackWireObjectFactory)) {
            return this.createCallbackObjectFactory(interfaze, multiThreaded, callbackUri, wire);
        }
        CallbackWireObjectFactory callbackFactory = (CallbackWireObjectFactory)factory;
        Map<Method, InvocationChain> operationMappings = this.createInterfaceToWireMapping(interfaze, wire);
        callbackFactory.updateMappings(callbackUri.toString(), operationMappings);
        return callbackFactory;
    }

    @Override
    public <T> T createProxy(Class<T> interfaze, String callbackUri, Map<Method, InvocationChain> mappings) throws ProxyCreationException {
        JDKInvocationHandler<T> handler = new JDKInvocationHandler<T>(interfaze, callbackUri, mappings);
        return handler.getService();
    }

    @Override
    public <T> T createMultiThreadedCallbackProxy(Class<T> interfaze, Map<String, Map<Method, InvocationChain>> mappings) throws ProxyCreationException {
        ClassLoader cl = interfaze.getClassLoader();
        MultiThreadedCallbackInvocationHandler handler = new MultiThreadedCallbackInvocationHandler(mappings);
        return interfaze.cast(Proxy.newProxyInstance(cl, new Class[]{interfaze}, handler));
    }

    @Override
    public <T> T createCallbackProxy(Class<T> interfaze, Map<Method, InvocationChain> mapping) {
        ClassLoader cl = interfaze.getClassLoader();
        StatefulCallbackInvocationHandler handler = new StatefulCallbackInvocationHandler(mapping);
        return interfaze.cast(Proxy.newProxyInstance(cl, new Class[]{interfaze}, handler));
    }

    public <B, R extends ServiceReference<B>> R cast(B target) throws IllegalArgumentException {
        InvocationHandler handler = Proxy.getInvocationHandler(target);
        if (handler instanceof JDKInvocationHandler) {
            JDKInvocationHandler jdkHandler = (JDKInvocationHandler)handler;
            return (R)jdkHandler.getServiceReference();
        }
        if (handler instanceof MultiThreadedCallbackInvocationHandler) {
            throw new UnsupportedOperationException();
        }
        throw new IllegalArgumentException("Not a Fabric3 SCA proxy");
    }

    private Map<Method, InvocationChain> createInterfaceToWireMapping(Class<?> interfaze, Wire wire) throws NoMethodForOperationException {
        List invocationChains = wire.getInvocationChains();
        HashMap<Method, InvocationChain> chains = new HashMap<Method, InvocationChain>(invocationChains.size());
        for (InvocationChain chain : invocationChains) {
            PhysicalOperationDefinition operation = chain.getPhysicalOperation();
            try {
                Method method = this.findMethod(interfaze, operation);
                chains.put(method, chain);
            }
            catch (NoSuchMethodException e) {
                throw new NoMethodForOperationException(operation.getName());
            }
            catch (ClassNotFoundException e) {
                throw new NoMethodForOperationException(e);
            }
        }
        return chains;
    }

    private Method findMethod(Class<?> clazz, PhysicalOperationDefinition operation) throws NoSuchMethodException, ClassNotFoundException {
        String name = operation.getName();
        List params = operation.getSourceParameterTypes();
        Class[] types = new Class[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            types[i] = this.classLoaderRegistry.loadClass(clazz.getClassLoader(), (String)params.get(i));
        }
        return clazz.getMethod(name, types);
    }
}

