/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.proxy.jdk.wire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import org.fabric3.spi.container.component.InstanceInvocationException;
import org.fabric3.spi.container.invocation.CallbackReference;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageCache;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;
import org.oasisopen.sca.ServiceUnavailableException;

public final class JDKInvocationHandler<B>
implements InvocationHandler,
ServiceReference<B> {
    private static final long serialVersionUID = -5841336280391145583L;
    private Class<B> interfaze;
    private B proxy;
    private Map<Method, InvocationChain> chains;
    private String callbackUri;

    public JDKInvocationHandler(Class<B> interfaze, String callbackUri, Map<Method, InvocationChain> mapping) {
        this.callbackUri = callbackUri;
        this.interfaze = interfaze;
        this.chains = mapping;
    }

    public B getService() {
        if (this.proxy == null) {
            ClassLoader loader = this.interfaze.getClassLoader();
            this.proxy = this.interfaze.cast(Proxy.newProxyInstance(loader, new Class[]{this.interfaze}, (InvocationHandler)this));
        }
        return this.proxy;
    }

    public Class<B> getBusinessInterface() {
        return this.interfaze;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InvocationChain chain = this.chains.get(method);
        if (chain == null) {
            return this.handleProxyMethod(method, args);
        }
        Interceptor headInterceptor = chain.getHeadInterceptor();
        assert (headInterceptor != null);
        WorkContext workContext = WorkContextCache.getThreadWorkContext();
        if (this.callbackUri != null) {
            this.initializeCallbackReference(workContext);
        }
        Message message = MessageCache.getAndResetMessage();
        message.setBody((Object)args);
        message.setWorkContext(workContext);
        try {
            Message response;
            try {
                response = headInterceptor.invoke(message);
            }
            catch (ServiceRuntimeException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ServiceUnavailableException((Throwable)e);
            }
            Object body = response.getBody();
            boolean fault = response.isFault();
            if (fault) {
                throw (Throwable)body;
            }
            Object object = body;
            return object;
        }
        finally {
            if (this.callbackUri != null) {
                workContext.popCallbackReference();
            }
            message.reset();
        }
    }

    public ServiceReference<B> getServiceReference() {
        return this;
    }

    private void initializeCallbackReference(WorkContext workContext) {
        CallbackReference callbackReference = new CallbackReference(this.callbackUri, null);
        workContext.addCallbackReference(callbackReference);
    }

    private Object handleProxyMethod(Method method, Object[] args) throws InstanceInvocationException {
        if (method.getParameterTypes().length == 0 && "toString".equals(method.getName())) {
            return "[Proxy - " + Integer.toHexString(this.hashCode()) + "]";
        }
        if (method.getDeclaringClass().equals(Object.class) && "equals".equals(method.getName()) && args.length == 1) {
            return this.proxyEquals(args[0]);
        }
        if (Object.class.equals(method.getDeclaringClass()) && "hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        String op = method.getName();
        throw new InstanceInvocationException("Operation not configured: " + op);
    }

    private Object proxyEquals(Object other) {
        if (other == null) {
            return false;
        }
        if (!Proxy.isProxyClass(other.getClass())) {
            return false;
        }
        InvocationHandler otherHandler = Proxy.getInvocationHandler(other);
        if (!(otherHandler instanceof JDKInvocationHandler)) {
            return false;
        }
        JDKInvocationHandler otherJDKHandler = (JDKInvocationHandler)otherHandler;
        return this.chains.equals(otherJDKHandler.chains);
    }
}

