/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.proxy.jdk.wire;

import java.lang.reflect.Method;
import java.util.Map;
import org.fabric3.implementation.pojo.spi.proxy.ProxyCreationException;
import org.fabric3.implementation.proxy.jdk.wire.JDKWireProxyService;
import org.fabric3.spi.container.invocation.CallbackReference;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.container.objectfactory.ObjectCreationException;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.InvocationChain;

public class CallbackWireObjectFactory<T>
implements ObjectFactory<T> {
    private Class<T> interfaze;
    private boolean multiThreaded;
    private JDKWireProxyService proxyService;
    private Map<String, Map<Method, InvocationChain>> mappings;
    private Map<Method, InvocationChain> singleMapping;

    public CallbackWireObjectFactory(Class<T> interfaze, boolean multiThreaded, JDKWireProxyService proxyService, Map<String, Map<Method, InvocationChain>> mappings) {
        this.interfaze = interfaze;
        this.multiThreaded = multiThreaded;
        this.proxyService = proxyService;
        this.mappings = mappings;
        if (mappings.size() == 1) {
            this.singleMapping = mappings.values().iterator().next();
        }
    }

    public T getInstance() throws ObjectCreationException {
        if (this.multiThreaded) {
            try {
                return this.interfaze.cast(this.proxyService.createMultiThreadedCallbackProxy(this.interfaze, this.mappings));
            }
            catch (ProxyCreationException e) {
                throw new ObjectCreationException((Throwable)e);
            }
        }
        CallbackReference callbackReference = WorkContextCache.getThreadWorkContext().peekCallbackReference();
        String callbackUri = callbackReference.getServiceUri();
        Map<Method, InvocationChain> mapping = this.singleMapping != null ? this.singleMapping : this.mappings.get(callbackUri);
        return this.interfaze.cast(this.proxyService.createCallbackProxy(this.interfaze, mapping));
    }

    public void updateMappings(String callbackUri, Map<Method, InvocationChain> chains) {
        this.mappings.put(callbackUri, chains);
        this.singleMapping = this.mappings.size() == 1 ? this.mappings.values().iterator().next() : null;
    }
}

