/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.proxy.jdk.wire;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.fabric3.spi.container.component.InstanceInvocationException;
import org.fabric3.spi.container.invocation.CallbackReference;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageCache;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.container.wire.InvocationChain;
import org.oasisopen.sca.ServiceUnavailableException;

public abstract class AbstractCallbackInvocationHandler<T>
implements InvocationHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(InvocationChain chain, Object[] args, WorkContext workContext) throws Throwable {
        CallbackReference callbackReference = workContext.popCallbackReference();
        Interceptor headInterceptor = chain.getHeadInterceptor();
        assert (headInterceptor != null);
        Message message = MessageCache.getAndResetMessage();
        message.setBody((Object)args);
        message.setWorkContext(workContext);
        try {
            Message response;
            try {
                response = headInterceptor.invoke(message);
            }
            catch (ServiceUnavailableException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ServiceUnavailableException((Throwable)e);
            }
            Object body = response.getBody();
            boolean fault = response.isFault();
            if (fault) {
                throw (Throwable)body;
            }
            Object object = body;
            return object;
        }
        finally {
            workContext.addCallbackReference(callbackReference);
            message.reset();
        }
    }

    protected Object handleProxyMethod(Method method) throws InstanceInvocationException {
        if (method.getParameterTypes().length == 0 && "toString".equals(method.getName())) {
            return "[Proxy - " + Integer.toHexString(this.hashCode()) + "]";
        }
        if (method.getDeclaringClass().equals(Object.class) && "equals".equals(method.getName())) {
            throw new UnsupportedOperationException();
        }
        if (Object.class.equals(method.getDeclaringClass()) && "hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        String op = method.getName();
        throw new InstanceInvocationException("Operation not configured: " + op);
    }
}

