/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.proxy.jdk.channel;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.container.component.InstanceInvocationException;

public final class JDKEventHandler
implements InvocationHandler {
    private EventStream stream;

    public JDKEventHandler(EventStream stream) {
        this.stream = stream;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (args == null || Object.class.equals(method.getDeclaringClass())) {
            this.handleProxyMethod(method);
            return null;
        }
        this.stream.getHeadHandler().handle(args[0], true);
        return null;
    }

    private Object handleProxyMethod(Method method) throws InstanceInvocationException {
        if (method.getParameterTypes().length == 0 && "toString".equals(method.getName())) {
            return "[Proxy - " + Integer.toHexString(this.hashCode()) + "]";
        }
        if (method.getDeclaringClass().equals(Object.class) && "equals".equals(method.getName())) {
            throw new UnsupportedOperationException();
        }
        if (Object.class.equals(method.getDeclaringClass()) && "hashCode".equals(method.getName())) {
            return this.hashCode();
        }
        String op = method.getName();
        throw new InstanceInvocationException("Operation not configured: " + op);
    }
}

