/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.wsdl.model;

import java.util.HashMap;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.contract.ServiceContract;

public class WsdlServiceContract
extends ServiceContract {
    private static final long serialVersionUID = 8084985972954894699L;
    private Map<QName, Object> extensionElements = new HashMap<QName, Object>();
    private PortType portType;
    private Definition definition;

    public WsdlServiceContract(PortType portType, Definition definition) {
        this.portType = portType;
        this.definition = definition;
    }

    public String getQualifiedInterfaceName() {
        return this.portType.getQName().toString();
    }

    public boolean isRemotable() {
        return true;
    }

    public void setRemotable(boolean remotable) {
        if (!remotable) {
            throw new IllegalArgumentException("WSDL interfaces are always remotable");
        }
    }

    public PortType getPortType() {
        return this.portType;
    }

    public QName getWsdlQName() {
        return this.definition.getQName();
    }

    public Definition getDefinition() {
        return this.definition;
    }

    public void addExtensionElement(QName key, Object element) {
        this.extensionElements.put(key, element);
    }

    public <T> T getExtensionElement(Class<T> type, QName key) {
        return type.cast(this.extensionElements.get(key));
    }

    public Map<QName, Object> getExtensionElements() {
        return this.extensionElements;
    }

    public WsdlServiceContract copy() {
        WsdlServiceContract copy = new WsdlServiceContract(this.portType, this.definition);
        copy.setCallbackContract(this.callbackContract);
        copy.setIntents(this.getIntents());
        copy.setInterfaceName(this.interfaceName);
        copy.setOperations(this.operations);
        copy.setPolicySets(this.getPolicySets());
        for (Map.Entry<QName, Object> entry : this.extensionElements.entrySet()) {
            copy.addExtensionElement(entry.getKey(), entry.getValue());
        }
        return copy;
    }
}

