/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.wsdl.loader;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.host.contribution.StoreException;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.ElementLoadFailure;
import org.fabric3.spi.introspection.xml.IncompatibleContracts;
import org.fabric3.spi.introspection.xml.InvalidValue;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.util.UriHelper;
import org.fabric3.wsdl.contribution.WsdlServiceContractSymbol;
import org.fabric3.wsdl.contribution.impl.PortTypeNotFound;
import org.fabric3.wsdl.model.WsdlServiceContract;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class InterfaceWsdlLoader
extends AbstractValidatingTypeLoader<WsdlServiceContract> {
    private MetaDataStore store;
    private ContractMatcher matcher;
    private LoaderHelper helper;

    public InterfaceWsdlLoader(@Reference MetaDataStore store, @Reference ContractMatcher matcher, @Reference LoaderHelper helper) {
        this.store = store;
        this.matcher = matcher;
        this.helper = helper;
        this.addAttributes(new String[]{"interface", "callbackInterface", "remotable", "requires", "policySets"});
    }

    public WsdlServiceContract load(XMLStreamReader reader, IntrospectionContext context) throws XMLStreamException {
        Location startLocation = reader.getLocation();
        this.validateRemotable(reader, startLocation, context);
        WsdlServiceContract wsdlContract = this.processInterface(reader, startLocation, context);
        this.processCallbackInterface(reader, wsdlContract, context);
        this.helper.loadPolicySetsAndIntents((PolicyAware)wsdlContract, reader, context);
        this.validateAttributes(reader, context, new ModelObject[]{wsdlContract});
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        return wsdlContract;
    }

    private WsdlServiceContract processInterface(XMLStreamReader reader, Location location, IntrospectionContext context) {
        Location startLocation = reader.getLocation();
        String interfaze = reader.getAttributeValue(null, "interface");
        if (interfaze == null) {
            MissingAttribute failure = new MissingAttribute("Interface attribute is required", startLocation, new ModelObject[0]);
            context.addError((ValidationFailure)failure);
            return new WsdlServiceContract(null, null);
        }
        QName portTypeName = this.parseQName(interfaze, location, context);
        if (portTypeName == null) {
            return new WsdlServiceContract(null, null);
        }
        return this.resolveContract(portTypeName, reader, context);
    }

    private void processCallbackInterface(XMLStreamReader reader, WsdlServiceContract wsdlContract, IntrospectionContext context) {
        Location startLocation = reader.getLocation();
        String callbackInterfaze = reader.getAttributeValue(null, "callbackInterface");
        if (callbackInterfaze != null) {
            MatchResult result;
            QName callbackName = this.parseQName(callbackInterfaze, startLocation, context);
            if (callbackName == null) {
                return;
            }
            WsdlServiceContract callbackContract = this.resolveContract(callbackName, reader, context);
            ServiceContract originalContract = wsdlContract.getCallbackContract();
            if (originalContract != null && !(result = this.matcher.isAssignableFrom((ServiceContract)callbackContract, originalContract, true)).isAssignable()) {
                IncompatibleContracts error = new IncompatibleContracts("The callback contract specified on interface.wsdl is not compatible with the one specified in the WSDL portType: " + result.getError(), startLocation, (ModelObject)callbackContract);
                context.addError((ValidationFailure)error);
            }
            wsdlContract.setCallbackContract(callbackContract);
        }
    }

    QName parseQName(String portType, Location location, IntrospectionContext context) {
        try {
            URI uri = new URI(portType);
            String namespace = UriHelper.getDefragmentedNameAsString((URI)uri);
            String localExpression = uri.getFragment();
            if (localExpression == null || !localExpression.toLowerCase().startsWith("wsdl.porttype(") || !localExpression.endsWith(")")) {
                InvalidValue error = new InvalidValue("A port type expression must be specified of the form <namespace>#wsdl.portType(portType): " + portType, location, new ModelObject[0]);
                context.addError((ValidationFailure)error);
                return null;
            }
            String localPart = localExpression.substring(14, localExpression.length() - 1);
            return new QName(namespace, localPart);
        }
        catch (URISyntaxException e) {
            InvalidValue error = new InvalidValue("Invalid port type identifier: " + portType, location, (Throwable)e, new ModelObject[0]);
            context.addError((ValidationFailure)error);
            return null;
        }
    }

    private WsdlServiceContract resolveContract(QName portTypeName, XMLStreamReader reader, IntrospectionContext context) {
        ResourceElement element;
        Location startLocation = reader.getLocation();
        WsdlServiceContractSymbol symbol = new WsdlServiceContractSymbol(portTypeName);
        URI contributionUri = context.getContributionUri();
        try {
            element = this.store.resolve(contributionUri, WsdlServiceContract.class, (Symbol)symbol, context);
        }
        catch (StoreException e) {
            ElementLoadFailure failure = new ElementLoadFailure("Error loading element", (Throwable)e, startLocation);
            context.addError((ValidationFailure)failure);
            return new WsdlServiceContract(null, null);
        }
        if (element == null) {
            PortTypeNotFound error = new PortTypeNotFound("Port type not found: " + portTypeName);
            context.addError((ValidationFailure)error);
            return new WsdlServiceContract(null, null);
        }
        WsdlServiceContract contract = (WsdlServiceContract)((Object)element.getValue());
        return contract.copy();
    }

    private void validateRemotable(XMLStreamReader reader, Location location, IntrospectionContext context) {
        boolean remotable;
        String remotableAttr = reader.getAttributeValue(null, "remotable");
        if (remotableAttr != null && !(remotable = Boolean.parseBoolean(remotableAttr))) {
            InvalidValue error = new InvalidValue("WSDL interfaces cannot set remotable to false", location, new ModelObject[0]);
            context.addError((ValidationFailure)error);
        }
    }
}

