/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.wsdl.contribution.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.schema.Schema;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaException;
import org.apache.ws.commons.schema.resolver.DefaultURIResolver;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.fabric3.api.host.contribution.InstallException;
import org.fabric3.api.host.contribution.StoreException;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.host.stream.Source;
import org.fabric3.spi.contribution.MetaDataStore;
import org.fabric3.spi.contribution.ProcessorRegistry;
import org.fabric3.spi.contribution.Resource;
import org.fabric3.spi.contribution.ResourceElement;
import org.fabric3.spi.contribution.ResourceProcessor;
import org.fabric3.spi.contribution.ResourceState;
import org.fabric3.spi.contribution.Symbol;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.wsdl.contribution.BindingSymbol;
import org.fabric3.wsdl.contribution.PortSymbol;
import org.fabric3.wsdl.contribution.PortTypeSymbol;
import org.fabric3.wsdl.contribution.ServiceSymbol;
import org.fabric3.wsdl.contribution.Wsdl4JFactory;
import org.fabric3.wsdl.contribution.WsdlResourceProcessorExtension;
import org.fabric3.wsdl.contribution.WsdlServiceContractSymbol;
import org.fabric3.wsdl.contribution.WsdlSymbol;
import org.fabric3.wsdl.contribution.impl.CallbackContractLoadError;
import org.fabric3.wsdl.contribution.impl.ContextClassLoaderResolver;
import org.fabric3.wsdl.contribution.impl.InvalidSchemaLocation;
import org.fabric3.wsdl.contribution.impl.InvalidWsdl;
import org.fabric3.wsdl.contribution.impl.PortTypeNotFound;
import org.fabric3.wsdl.contribution.impl.RelativeUrlResolver;
import org.fabric3.wsdl.contribution.impl.SourceWsdlLocator;
import org.fabric3.wsdl.model.WsdlServiceContract;
import org.fabric3.wsdl.processor.WsdlContractProcessor;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@EagerInit
public class WsdlResourceProcessor
implements ResourceProcessor {
    private static final QName SCHEMA_NAME = new QName("http://www.w3.org/2001/XMLSchema", "schema");
    private static final QName IMPORT_NAME = new QName("http://www.w3.org/2001/XMLSchema", "import");
    private static final QName SCHEMA_LOCATION = new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
    private static final QName CALLBACK_ATTRIBUTE = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "callback");
    private static final String MIME_TYPE = "text/wsdl+xml";
    private ProcessorRegistry registry;
    private WsdlContractProcessor processor;
    private MetaDataStore store;
    private Wsdl4JFactory factory;
    private DocumentBuilderFactory documentBuilderFactory;
    private List<WsdlResourceProcessorExtension> extensions = new ArrayList<WsdlResourceProcessorExtension>();

    public WsdlResourceProcessor(@Reference ProcessorRegistry registry, @Reference WsdlContractProcessor processor, @Reference MetaDataStore store, @Reference Wsdl4JFactory factory) {
        this.registry = registry;
        this.processor = processor;
        this.store = store;
        this.factory = factory;
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        this.documentBuilderFactory.setNamespaceAware(true);
    }

    @Reference(required=false)
    public void setExtensions(List<WsdlResourceProcessorExtension> extensions) {
        this.extensions = extensions;
    }

    @Init
    public void init() {
        this.registry.register((ResourceProcessor)this);
    }

    public String getContentType() {
        return MIME_TYPE;
    }

    public void index(Resource resource, IntrospectionContext context) throws InstallException {
        InputStream stream = null;
        try {
            Source source = resource.getSource();
            stream = source.openStream();
            this.parse(resource, context);
        }
        catch (IOException e) {
            throw new InstallException((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void process(Resource resource, IntrospectionContext context) throws InstallException {
        Definition definition = this.resolveLocalWsdl(resource);
        for (ResourceElement element : resource.getResourceElements()) {
            WsdlServiceContract contract;
            PortType portType;
            QName callbackPortTypeName;
            if (!(element.getSymbol() instanceof WsdlServiceContractSymbol) || (callbackPortTypeName = (QName)(portType = (contract = (WsdlServiceContract)((Object)element.getValue())).getPortType()).getExtensionAttribute(CALLBACK_ATTRIBUTE)) == null) continue;
            PortType callbackPortType = definition.getPortType(callbackPortTypeName);
            if (callbackPortType != null) {
                this.resolveLocalCallbackContract(callbackPortTypeName, contract, resource, context);
                continue;
            }
            this.resolveExternalCallbackContract(callbackPortTypeName, contract, context);
        }
        resource.setState(ResourceState.PROCESSED);
    }

    private void parse(Resource resource, IntrospectionContext context) throws InstallException {
        Source source = resource.getSource();
        Definition definition = this.parseWsdl(source, context);
        QName wsdlQName = definition.getQName();
        WsdlSymbol wsdlSymbol = new WsdlSymbol(wsdlQName);
        ResourceElement wsdlElement = new ResourceElement((Symbol)wsdlSymbol, (Object)definition);
        resource.addResourceElement(wsdlElement);
        Map services = definition.getServices();
        for (Service service : services.values()) {
            ServiceSymbol serviceSymbol = new ServiceSymbol(service.getQName());
            ResourceElement serviceElement = new ResourceElement((Symbol)serviceSymbol, (Object)service);
            resource.addResourceElement(serviceElement);
            Map ports = service.getPorts();
            for (Port port : ports.values()) {
                QName portName = new QName(definition.getTargetNamespace(), port.getName());
                PortSymbol portSymbol = new PortSymbol(portName);
                ResourceElement portElement = new ResourceElement((Symbol)portSymbol, (Object)port);
                resource.addResourceElement(portElement);
            }
        }
        for (Object object : definition.getPortTypes().values()) {
            PortType portType = (PortType)object;
            QName name = portType.getQName();
            PortTypeSymbol symbol = new PortTypeSymbol(name);
            ResourceElement element = new ResourceElement((Symbol)symbol, (Object)portType);
            resource.addResourceElement(element);
        }
        XmlSchemaCollection schemaCollection = this.parseSchema(definition, context);
        for (Object object : definition.getPortTypes().values()) {
            PortType portType = (PortType)object;
            WsdlServiceContract contract = this.processor.introspect(portType, definition, schemaCollection, context);
            QName name = portType.getQName();
            WsdlServiceContractSymbol symbol = new WsdlServiceContractSymbol(name);
            ResourceElement element = new ResourceElement((Symbol)symbol, (Object)contract);
            resource.addResourceElement(element);
        }
        Collection bindings = definition.getBindings().values();
        for (Binding binding : bindings) {
            BindingSymbol bindingSymbol = new BindingSymbol(binding.getQName());
            ResourceElement serviceElement = new ResourceElement((Symbol)bindingSymbol, (Object)binding);
            resource.addResourceElement(serviceElement);
        }
        for (WsdlResourceProcessorExtension extension : this.extensions) {
            extension.process(resource, definition);
        }
    }

    private Definition parseWsdl(Source source, IntrospectionContext context) throws InstallException {
        try (SourceWsdlLocator locator = new SourceWsdlLocator(source, context);){
            WSDLReader reader = this.factory.newReader();
            Definition definition = reader.readWSDL((WSDLLocator)locator);
            if (!definition.getNamespaces().values().contains("http://schemas.xmlsoap.org/wsdl/soap/")) {
                definition.addNamespace("soap11", "http://schemas.xmlsoap.org/wsdl/soap/");
            }
            this.parseSchemaLocation(definition, context);
            Definition definition2 = definition;
            return definition2;
        }
    }

    private void parseSchemaLocation(Definition definition, IntrospectionContext context) throws InstallException {
        QName schemaLocation = (QName)definition.getExtensionAttribute(SCHEMA_LOCATION);
        if (schemaLocation == null) {
            return;
        }
        String trimmed = schemaLocation.getLocalPart().replaceAll("\\s{2,}", " ");
        String[] locationValue = trimmed.split(" ");
        int len = locationValue.length;
        if (len == 1) {
            this.populateSchemaTypes(definition, "", locationValue[0]);
        } else if (len > 1) {
            if (len % 2 != 0) {
                InvalidSchemaLocation error = new InvalidSchemaLocation("Invalid schemaLocation value: " + schemaLocation.getLocalPart());
                context.addError((ValidationFailure)error);
                return;
            }
            for (int i = 0; i < locationValue.length - 1; ++i) {
                String namespace = locationValue[i];
                String location = locationValue[i + 1];
                this.populateSchemaTypes(definition, namespace, location);
            }
        }
    }

    private void populateSchemaTypes(Definition definition, String targetNamespace, String schemaLocation) throws InstallException {
        Document document;
        Schema schema;
        Types types = definition.createTypes();
        try {
            schema = (Schema)definition.getExtensionRegistry().createExtension(Types.class, SCHEMA_NAME);
        }
        catch (WSDLException e) {
            throw new InstallException((Throwable)e);
        }
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new InstallException((Throwable)e);
        }
        Element schemaElement = document.createElementNS(SCHEMA_NAME.getNamespaceURI(), "xsd:schema");
        schema.setElement(schemaElement);
        Element importElement = document.createElementNS(IMPORT_NAME.getNamespaceURI(), "xsd:import");
        importElement.setAttribute("namespace", targetNamespace);
        importElement.setAttribute("schemaLocation", schemaLocation);
        schemaElement.appendChild(importElement);
        types.addExtensibilityElement((ExtensibilityElement)schema);
        definition.setTypes(types);
    }

    private XmlSchemaCollection parseSchema(Definition definition, IntrospectionContext context) {
        XmlSchemaCollection collection = new XmlSchemaCollection();
        collection.setSchemaResolver(this.createResolvers(collection));
        try {
            Types types = definition.getTypes();
            if (types == null) {
                return collection;
            }
            for (Object obj : types.getExtensibilityElements()) {
                if (!(obj instanceof Schema)) continue;
                Schema schema = (Schema)obj;
                Element element = schema.getElement();
                collection.setBaseUri(schema.getDocumentBaseURI());
                String syntheticId = definition.getDocumentBaseURI() + "#" + UUID.randomUUID().toString();
                collection.read(element, syntheticId);
            }
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof XmlSchemaException)) {
                throw e;
            }
            InvalidWsdl error = new InvalidWsdl("Error parsing Schema", e.getCause());
            context.addError((ValidationFailure)error);
        }
        return collection;
    }

    private URIResolver createResolvers(XmlSchemaCollection collection) {
        DefaultURIResolver defaultResolver = new DefaultURIResolver();
        ContextClassLoaderResolver classLoaderResolver = new ContextClassLoaderResolver((URIResolver)defaultResolver);
        return new RelativeUrlResolver(collection, classLoaderResolver);
    }

    private Definition resolveLocalWsdl(Resource resource) {
        Definition definition = null;
        for (ResourceElement element : resource.getResourceElements()) {
            if (!(element.getSymbol() instanceof WsdlSymbol)) continue;
            definition = (Definition)element.getValue();
            break;
        }
        if (definition == null) {
            throw new AssertionError((Object)"WSDL document not found");
        }
        return definition;
    }

    private void resolveExternalCallbackContract(QName callbackPortTypeName, WsdlServiceContract contract, IntrospectionContext context) {
        ResourceElement resolved;
        WsdlServiceContractSymbol symbol = new WsdlServiceContractSymbol(callbackPortTypeName);
        URI contributionUri = context.getContributionUri();
        try {
            resolved = this.store.resolve(contributionUri, WsdlServiceContract.class, (Symbol)symbol, context);
        }
        catch (StoreException e) {
            CallbackContractLoadError error = new CallbackContractLoadError("Error resolving callback port type:" + callbackPortTypeName, e);
            context.addError((ValidationFailure)error);
            return;
        }
        if (resolved == null) {
            PortTypeNotFound error = new PortTypeNotFound("Callback port type not found: " + callbackPortTypeName);
            context.addError((ValidationFailure)error);
            return;
        }
        WsdlServiceContract callbackContract = (WsdlServiceContract)((Object)resolved.getValue());
        contract.setCallbackContract(callbackContract);
    }

    private void resolveLocalCallbackContract(QName callbackPortTypeName, WsdlServiceContract contract, Resource resource, IntrospectionContext context) {
        WsdlServiceContractSymbol symbol = new WsdlServiceContractSymbol(callbackPortTypeName);
        for (ResourceElement resourceElement : resource.getResourceElements()) {
            if (!resourceElement.getSymbol().equals((Object)symbol)) continue;
            WsdlServiceContract callbackContract = (WsdlServiceContract)((Object)resourceElement.getValue());
            contract.setCallbackContract(callbackContract);
            break;
        }
        if (contract.getCallbackContract() == null) {
            PortTypeNotFound error = new PortTypeNotFound("Callback port type not found: " + callbackPortTypeName);
            context.addError((ValidationFailure)error);
        }
    }
}

