/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.wsdl.contribution.impl;

import java.util.ArrayList;
import java.util.List;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionDeserializer;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.extensions.ExtensionSerializer;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.fabric3.wsdl.contribution.Wsdl4JFactory;

public class Wsdl4JFactoryImpl
implements Wsdl4JFactory {
    private static final String VERBOSE = "javax.wsdl.verbose";
    private WSDLFactory factory;
    private List<Holder> holders = new ArrayList<Holder>();

    public Wsdl4JFactoryImpl() throws WSDLException {
        this.factory = WSDLFactory.newInstance();
    }

    @Override
    public void register(Class<?> parentType, QName elementType, Class<?> extensionType, ExtensionSerializer serializer, ExtensionDeserializer deserializer) {
        Holder holder = new Holder(parentType, elementType, extensionType, deserializer, serializer);
        this.holders.add(holder);
    }

    @Override
    public void unregister(Class parentType, QName elementType, Class<?> extensionType) {
        Holder holder = new Holder(parentType, elementType, extensionType, null, null);
        this.holders.remove(holder);
    }

    @Override
    public WSDLReader newReader() {
        WSDLReader reader = this.factory.newWSDLReader();
        reader.setFeature(VERBOSE, false);
        ExtensionRegistry registry = this.createRegistry();
        reader.setExtensionRegistry(registry);
        return reader;
    }

    @Override
    public WSDLWriter newWriter() {
        return this.factory.newWSDLWriter();
    }

    private ExtensionRegistry createRegistry() {
        ExtensionRegistry registry = this.factory.newPopulatedExtensionRegistry();
        for (Holder holder : this.holders) {
            Class parentType = holder.getParentType();
            QName elementType = holder.getElementType();
            Class<?> extensionType = holder.getExtensionType();
            ExtensionDeserializer deserializer = holder.getDeserializer();
            ExtensionSerializer serializer = holder.getSerializer();
            registry.registerDeserializer(parentType, elementType, deserializer);
            registry.registerSerializer(parentType, elementType, serializer);
            registry.mapExtensionTypes(holder.getParentType(), holder.getElementType(), extensionType);
        }
        return registry;
    }

    private class Holder {
        private Class<?> parentType;
        private QName elementType;
        private Class<?> extensionType;
        private ExtensionDeserializer deserializer;
        private ExtensionSerializer serializer;

        private Holder(Class<?> parentType, QName elementType, Class<?> extensionType, ExtensionDeserializer deserializer, ExtensionSerializer serializer) {
            this.parentType = parentType;
            this.elementType = elementType;
            this.extensionType = extensionType;
            this.deserializer = deserializer;
            this.serializer = serializer;
        }

        public Class getParentType() {
            return this.parentType;
        }

        public QName getElementType() {
            return this.elementType;
        }

        public Class<?> getExtensionType() {
            return this.extensionType;
        }

        public ExtensionDeserializer getDeserializer() {
            return this.deserializer;
        }

        public ExtensionSerializer getSerializer() {
            return this.serializer;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Holder holder = (Holder)o;
            return !((this.elementType == null ? holder.elementType != null : !this.elementType.equals(holder.elementType)) || (this.extensionType == null ? holder.extensionType != null : !this.extensionType.equals(holder.extensionType)) || (this.parentType == null ? holder.parentType != null : !this.parentType.equals(holder.parentType)));
        }

        public int hashCode() {
            int result = this.parentType != null ? this.parentType.hashCode() : 0;
            result = 31 * result + (this.elementType != null ? this.elementType.hashCode() : 0);
            result = 31 * result + (this.extensionType != null ? this.extensionType.hashCode() : 0);
            result = 31 * result + (this.deserializer != null ? this.deserializer.hashCode() : 0);
            result = 31 * result + (this.serializer != null ? this.serializer.hashCode() : 0);
            return result;
        }
    }
}

