/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.wsdl.contribution.impl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.wsdl.xml.WSDLLocator;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.host.stream.Source;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.wsdl.contribution.impl.InvalidWsdl;
import org.xml.sax.InputSource;

public class SourceWsdlLocator
implements WSDLLocator {
    private Source mSource;
    private IntrospectionContext mContext;
    private String mLatestImportURI;
    private List<InputStream> mStreams;

    public SourceWsdlLocator(Source aSource, IntrospectionContext aContext) {
        this.mSource = aSource;
        this.mContext = aContext;
        this.mStreams = new ArrayList<InputStream>();
    }

    public InputSource getBaseInputSource() {
        try {
            return new InputSource(this.addStream(this.mSource.openStream()));
        }
        catch (IOException ex) {
            this.mContext.addError((ValidationFailure)new InvalidWsdl(ex.getLocalizedMessage(), ex));
            return null;
        }
    }

    public String getBaseURI() {
        return this.mSource.getSystemId();
    }

    public InputSource getImportInputSource(String aParentLocation, String aImportLocation) {
        try {
            Source importSource = this.mSource.getImportSource(aParentLocation, aImportLocation);
            if (importSource != null) {
                this.mLatestImportURI = importSource.getSystemId();
                return new InputSource(this.addStream(importSource.openStream()));
            }
        }
        catch (IOException ex) {
            this.mContext.addError((ValidationFailure)new InvalidWsdl(ex.getLocalizedMessage(), ex));
        }
        return null;
    }

    public String getLatestImportURI() {
        return this.mLatestImportURI;
    }

    public void close() {
        for (InputStream stream : this.mStreams) {
            try {
                stream.close();
            }
            catch (Throwable throwable) {}
        }
    }

    private InputStream addStream(InputStream aStream) {
        if (aStream != null) {
            this.mStreams.add(aStream);
        }
        return aStream;
    }
}

