/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.wsdl.contribution.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URL;
import java.util.ListIterator;
import java.util.Stack;
import java.util.UUID;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.fabric3.api.host.util.IOHelper;
import org.xml.sax.InputSource;

public class RelativeUrlResolver
implements URIResolver {
    private static Field schemaKeyIdField;
    private URIResolver next;
    private XmlSchemaCollection collection;
    private Field stackField;

    public RelativeUrlResolver(XmlSchemaCollection collection, URIResolver next) {
        this.collection = collection;
        this.next = next;
        try {
            this.stackField = XmlSchemaCollection.class.getDeclaredField("stack");
            this.stackField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
        String base = this.getBase(baseUri);
        try {
            URL url = new URL(new URL(base), schemaLocation);
            InputStream stream = null;
            try {
                stream = url.openStream();
                if (stream == null) return this.next.resolveEntity(targetNamespace, schemaLocation, baseUri);
                InputSource inputSource = this.createSource(url);
                return inputSource;
            }
            catch (IOException e) {
                InputSource inputSource = this.next.resolveEntity(targetNamespace, schemaLocation, baseUri);
                return inputSource;
            }
            finally {
                IOHelper.closeQuietly((Closeable)stream);
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        return this.next.resolveEntity(targetNamespace, schemaLocation, baseUri);
    }

    private String getBase(String baseUri) {
        int pos = baseUri.indexOf("#");
        String base = baseUri;
        if (pos > 0) {
            base = baseUri.substring(0, pos);
        }
        Stack stack = this.getStack();
        URI uri = URI.create(base);
        if (!stack.isEmpty()) {
            ListIterator iterator = stack.listIterator(stack.size());
            for (int index = stack.size() - 1; iterator.hasPrevious() && index != 0; --index) {
                Object key = iterator.previous();
                uri = this.buildUri(base, key);
            }
        }
        if (uri != null) {
            return uri.toString();
        }
        return base;
    }

    private URI buildUri(String base, Object key) {
        String current = this.getSystemId(key);
        current = current.substring(0, current.indexOf("#"));
        String schemeBase = URI.create(base).getSchemeSpecificPart();
        String relativeScheme = URI.create(current).getSchemeSpecificPart();
        return URI.create("jar:" + URI.create(schemeBase).resolve(relativeScheme).toString());
    }

    private String getSystemId(Object key) {
        try {
            if (schemaKeyIdField == null) {
                schemaKeyIdField = key.getClass().getDeclaredField("systemId");
                schemaKeyIdField.setAccessible(true);
            }
            return (String)schemaKeyIdField.get(key);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new AssertionError((Object)e);
        }
    }

    private InputSource createSource(URL url) {
        try {
            InputSource source = new InputSource(url.openStream());
            source.setSystemId(url.toString() + "#" + UUID.randomUUID().toString());
            return source;
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    private Stack getStack() {
        try {
            return (Stack)this.stackField.get(this.collection);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }
}

