/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.wsdl.contract;

import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.spi.contract.ContractMatcherExtension;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.model.type.xsd.XSDComplexType;
import org.fabric3.spi.model.type.xsd.XSDType;

public abstract class AbstractXsdContractMatcherExtension<S extends ServiceContract, T extends ServiceContract>
implements ContractMatcherExtension<S, T> {
    protected MatchResult matchContract(ServiceContract source, ServiceContract target, boolean reportErrors) {
        if (source == target) {
            return MatchResult.MATCH;
        }
        if (source.getCallbackContract() == null && target.getCallbackContract() != null || source.getCallbackContract() != null && target.getCallbackContract() == null) {
            if (reportErrors) {
                return new MatchResult("Callback contracts do not match");
            }
            return MatchResult.NO_MATCH;
        }
        for (Operation operation : source.getOperations()) {
            MatchResult match = this.matchOperation(operation, target.getOperations(), reportErrors);
            if (match.isAssignable()) continue;
            return match;
        }
        return MatchResult.MATCH;
    }

    protected MatchResult matchOperation(Operation operation, List<Operation> operations, boolean reportErrors) {
        boolean matched = false;
        for (Operation candidate : operations) {
            String name = operation.getName();
            String wsdlName = operation.getWsdlName();
            if (!name.equalsIgnoreCase(candidate.getName()) && (wsdlName == null || !wsdlName.equals(candidate.getWsdlName()))) continue;
            List inputTypes = operation.getInputTypes();
            List candidateInputTypes = candidate.getInputTypes();
            if (inputTypes.size() != candidateInputTypes.size()) {
                if (reportErrors) {
                    return new MatchResult("The number of parameters for the source and target operations are not equal for operation " + name);
                }
                return MatchResult.NO_MATCH;
            }
            for (int i = 0; i < inputTypes.size(); ++i) {
                DataType inputType = (DataType)inputTypes.get(i);
                DataType candidateInputType = (DataType)candidateInputTypes.get(i);
                if (inputType.getXsdType() != null && inputType.getXsdType().equals(candidateInputType.getXsdType()) || inputType instanceof XSDComplexType && this.checkSequence((XSDComplexType)inputType, candidateInputType) || candidateInputType instanceof XSDComplexType && this.checkSequence((XSDComplexType)candidateInputType, inputType)) continue;
                if (reportErrors) {
                    return new MatchResult("Input types at position " + i + " do not match on operation " + name);
                }
                return MatchResult.NO_MATCH;
            }
            DataType outputType = operation.getOutputType();
            QName outputXsdType = outputType.getXsdType();
            DataType candidateOutputType = candidate.getOutputType();
            QName candidateOutputXsdType = candidateOutputType.getXsdType();
            if (outputXsdType == null || !outputXsdType.equals(candidateOutputXsdType)) {
                if (outputType instanceof XSDComplexType && this.checkSequence((XSDComplexType)outputType, candidateOutputType)) {
                    matched = true;
                    break;
                }
                if (candidateOutputType instanceof XSDComplexType && this.checkSequence((XSDComplexType)candidateOutputType, outputType)) {
                    matched = true;
                    break;
                }
                if (reportErrors) {
                    return new MatchResult("Output types do not match on operation " + name + ". Types were " + outputType.getXsdType() + " and " + candidateOutputType.getXsdType());
                }
                return MatchResult.NO_MATCH;
            }
            matched = true;
        }
        if (matched) {
            return MatchResult.MATCH;
        }
        if (reportErrors) {
            return new MatchResult("No matching operation for: " + operation.getName());
        }
        return MatchResult.NO_MATCH;
    }

    private boolean checkSequence(XSDComplexType complexType, DataType type) {
        if (complexType.isSequence() && complexType.getSequenceTypes().size() == 1) {
            XSDType sequenceType = (XSDType)complexType.getSequenceTypes().get(0);
            if (sequenceType.getXsdType().equals(type.getXsdType())) {
                return true;
            }
            if (type.getXsdType().getNamespaceURI().equals("http://util.java/") && type.getXsdType().getLocalPart().equals("list")) {
                return true;
            }
        }
        return false;
    }
}

