/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.policy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.List;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.fabric3.spi.introspection.java.policy.OperationPolicyIntrospector;
import org.oasisopen.sca.annotation.Reference;

public class DefaultOperationPolicyIntrospector
implements OperationPolicyIntrospector {
    private PolicyAnnotationProcessor policyProcessor;

    public DefaultOperationPolicyIntrospector(@Reference PolicyAnnotationProcessor policyProcessor) {
        this.policyProcessor = policyProcessor;
    }

    public void introspectPolicyOnOperations(ServiceContract contract, Class<?> implClass, IntrospectionContext context) {
        for (Operation operation : contract.getOperations()) {
            List types = operation.getInputTypes();
            Class[] params = new Class[types.size()];
            for (int i = 0; i < types.size(); ++i) {
                Class type;
                DataType dataType = (DataType)types.get(i);
                params[i] = type = dataType.getType();
            }
            try {
                Method method = implClass.getMethod(operation.getName(), params);
                for (Annotation annotation : method.getAnnotations()) {
                    this.policyProcessor.process(annotation, (PolicyAware)operation, context);
                }
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

