/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import org.fabric3.api.annotation.Producer;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.component.ProducerDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.introspection.java.annotation.InvalidProducerInterface;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ProducerProcessor
extends AbstractAnnotationProcessor<Producer> {
    private JavaContractProcessor contractProcessor;
    private IntrospectionHelper helper;

    public ProducerProcessor(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        super(Producer.class);
        this.contractProcessor = contractProcessor;
        this.helper = helper;
    }

    public void visitField(Producer annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(field, annotation.value());
        Type type = field.getGenericType();
        FieldInjectionSite site = new FieldInjectionSite(field);
        ProducerDefinition definition = this.createDefinition(name, type, implClass, componentType, field, context);
        Class<?> clazz = field.getDeclaringClass();
        this.processTargets(annotation, definition, field, clazz, context);
        componentType.add(definition, (InjectionSite)site);
    }

    public void visitMethod(Producer annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(method, annotation.value());
        Type type = this.helper.getGenericType(method);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        ProducerDefinition definition = this.createDefinition(name, type, implClass, componentType, method, context);
        Class<?> clazz = method.getDeclaringClass();
        this.processTargets(annotation, definition, method, clazz, context);
        componentType.add(definition, (InjectionSite)site);
    }

    public void visitConstructorParameter(Producer annotation, Constructor<?> constructor, int index, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(constructor, index, annotation.value());
        Type type = this.helper.getGenericType(constructor, index);
        ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, index);
        ProducerDefinition definition = this.createDefinition(name, type, implClass, componentType, constructor, context);
        Class<?> clazz = constructor.getDeclaringClass();
        this.processTargets(annotation, definition, constructor, clazz, context);
        componentType.add(definition, (InjectionSite)site);
    }

    private ProducerDefinition createDefinition(String name, Type type, Class<?> implClass, InjectingComponentType componentType, Member member, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class baseType = this.helper.getBaseType(type, typeMapping);
        JavaServiceContract contract = this.contractProcessor.introspect(baseType, implClass, context, new ModelObject[]{componentType});
        if (contract.getOperations().size() != 1) {
            String interfaceName = contract.getInterfaceName();
            InvalidProducerInterface error = new InvalidProducerInterface("Producer interfaces must have one method: " + interfaceName, member, componentType);
            context.addError((ValidationFailure)error);
        }
        return new ProducerDefinition(name, (ServiceContract)contract);
    }

    private void processTargets(Producer annotation, ProducerDefinition definition, AnnotatedElement element, Class<?> clazz, IntrospectionContext context) {
        try {
            if (annotation.targets().length > 0) {
                for (String target : annotation.targets()) {
                    definition.addTarget(new URI(target));
                }
            } else if (annotation.target().length() > 0) {
                definition.addTarget(new URI(annotation.target()));
            }
        }
        catch (URISyntaxException e) {
            InvalidAnnotation error = new InvalidAnnotation("Invalid producer target on : " + clazz.getName(), element, (Annotation)annotation, clazz, (Exception)e);
            context.addError((ValidationFailure)error);
        }
    }
}

