/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.IntentMetaData;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.introspection.java.annotation.InvalidIntentName;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.oasisopen.sca.annotation.Intent;
import org.oasisopen.sca.annotation.PolicySets;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Qualifier;
import org.oasisopen.sca.annotation.Requires;

public class PolicyAnnotationProcessorImpl
implements PolicyAnnotationProcessor {
    private Map<String, QName> intentsToQualifiers = new HashMap<String, QName>();

    @Property(required=false)
    public void setIntentsToQualifiers(Map<String, QName> intentsToQualifiers) {
        this.intentsToQualifiers = intentsToQualifiers;
    }

    public void process(Annotation annotation, PolicyAware modelObject, IntrospectionContext context) {
        if (annotation instanceof Requires) {
            this.processRequires((Requires)annotation, modelObject, context);
        } else if (annotation instanceof PolicySets) {
            this.processPolicySets((PolicySets)annotation, modelObject, context);
        } else {
            this.processIntentAnnotation(annotation, modelObject, context);
        }
    }

    private void processRequires(Requires annotation, PolicyAware modelObject, IntrospectionContext context) {
        String[] intents;
        for (String intent : intents = annotation.value()) {
            try {
                QName qName = QName.valueOf(intent);
                modelObject.addIntent(qName);
            }
            catch (IllegalArgumentException e) {
                InvalidIntentName error = new InvalidIntentName(intent, annotation.getClass(), e);
                context.addError((ValidationFailure)error);
            }
        }
    }

    private void processPolicySets(PolicySets annotation, PolicyAware modelObject, IntrospectionContext context) {
        String[] policySets;
        for (String set : policySets = annotation.value()) {
            try {
                QName qName = QName.valueOf(set);
                modelObject.addPolicySet(qName);
            }
            catch (IllegalArgumentException e) {
                InvalidIntentName error = new InvalidIntentName(set, null, e);
                context.addError((ValidationFailure)error);
            }
        }
    }

    private void processIntentAnnotation(Annotation annotation, PolicyAware modelObject, IntrospectionContext context) {
        Class<? extends Annotation> annotClass = annotation.annotationType();
        if (annotClass.isAnnotationPresent(Intent.class)) {
            Intent intent = annotClass.getAnnotation(Intent.class);
            String val = intent.value();
            try {
                String[] qualifiers = this.getMetadataValue(annotation, Qualifier.class, context);
                QName name = null;
                if (qualifiers == null || qualifiers.length < 1 || qualifiers[0].length() < 1) {
                    name = QName.valueOf(val);
                } else {
                    for (String qualifier : qualifiers) {
                        name = QName.valueOf(qualifier);
                    }
                }
                modelObject.addIntent(name);
                String[] metadata = this.getMetadataValue(annotation, IntentMetaData.class, context);
                if (metadata != null && metadata.length >= 1 && metadata[0].length() >= 1) {
                    modelObject.addMetadata(name, (Serializable)metadata);
                }
            }
            catch (IllegalArgumentException e) {
                context.addError((ValidationFailure)new InvalidIntentName(val, annotClass, e));
            }
            catch (IllegalAccessException e) {
                context.addError((ValidationFailure)new InvalidAnnotation("Error reading annotation value " + annotClass.getName(), annotClass, annotation, annotClass, (Exception)e));
            }
            catch (InvocationTargetException e) {
                context.addError((ValidationFailure)new InvalidAnnotation("Error reading annotation value" + annotClass.getName(), annotClass, annotation, annotClass, (Exception)e));
            }
        } else {
            QName qualifier = this.intentsToQualifiers.get(annotation.annotationType().getName());
            if (qualifier != null) {
                modelObject.addIntent(qualifier);
            }
        }
    }

    private String[] getMetadataValue(Annotation annotation, Class<? extends Annotation> metadataAnnotClass, IntrospectionContext context) throws IllegalAccessException, InvocationTargetException {
        Class<? extends Annotation> annotClass = annotation.annotationType();
        for (Method method : annotClass.getMethods()) {
            if (!method.isAnnotationPresent(metadataAnnotClass)) continue;
            Class<?> type = method.getReturnType();
            if (type.isArray() && String.class.equals(type.getComponentType())) {
                return (String[])method.invoke((Object)annotation, new Object[0]);
            }
            if (String.class.equals(type)) {
                String ret = (String)method.invoke((Object)annotation, new Object[0]);
                return new String[]{ret};
            }
            String metadataName = metadataAnnotClass.getName();
            String annotationName = annotClass.getName();
            InvalidAnnotation error = new InvalidAnnotation("Value for " + metadataName + " must be String or String[] on " + annotationName, annotClass, annotation, annotClass);
            context.addError((ValidationFailure)error);
        }
        return null;
    }
}

