/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.fabric3.api.annotation.Source;
import org.fabric3.api.annotation.model.Component;
import org.fabric3.api.annotation.model.Namespace;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.component.ComponentType;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.introspection.java.annotation.InvalidAccessor;
import org.fabric3.introspection.java.annotation.InvalidMethod;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.fabric3.spi.introspection.java.MultiplicityType;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

public class OASISPropertyProcessor
extends AbstractAnnotationProcessor<Property> {
    private final IntrospectionHelper helper;

    public OASISPropertyProcessor(@Reference IntrospectionHelper helper) {
        super(Property.class);
        this.helper = helper;
    }

    public void visitField(Property annotation, Field field, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        this.validate(annotation, field, componentType, context);
        String name = this.helper.getSiteName(field, annotation.name());
        Type type = field.getGenericType();
        FieldInjectionSite site = new FieldInjectionSite(field);
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        boolean required = annotation.required();
        org.fabric3.api.model.type.component.Property property = this.createDefinition(name, required, type, typeMapping);
        this.processSource(field, field.getDeclaringClass(), property, context);
        componentType.add(property, (InjectionSite)site);
    }

    public void visitMethod(Property annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        boolean result = this.validate(annotation, method, componentType, context);
        if (!result) {
            return;
        }
        String name = this.helper.getSiteName(method, annotation.name());
        Type type = this.helper.getGenericType(method);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        boolean required = annotation.required();
        org.fabric3.api.model.type.component.Property property = this.createDefinition(name, required, type, typeMapping);
        this.processSource(method, method.getDeclaringClass(), property, context);
        componentType.add(property, (InjectionSite)site);
    }

    public void visitConstructorParameter(Property annotation, Constructor<?> constructor, int index, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        String name = this.helper.getSiteName(constructor, index, annotation.name());
        Type type = this.helper.getGenericType(constructor, index);
        ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, index);
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        boolean required = annotation.required();
        org.fabric3.api.model.type.component.Property property = this.createDefinition(name, required, type, typeMapping);
        Class<?> paramType = constructor.getParameterTypes()[index];
        Class<?> declaringClass = constructor.getDeclaringClass();
        this.processSource(paramType, declaringClass, property, context);
        componentType.add(property, (InjectionSite)site);
    }

    private void validate(Property annotation, Field field, InjectingComponentType componentType, IntrospectionContext context) {
        if (!Modifier.isProtected(field.getModifiers()) && !Modifier.isPublic(field.getModifiers())) {
            Class<?> clazz = field.getDeclaringClass();
            if (annotation.required()) {
                InvalidAccessor error = new InvalidAccessor("Invalid required property. The field " + field.getName() + " on " + clazz.getName() + " is annotated with @Property but properties must be public or protected.", field, (ComponentType)componentType);
                context.addError((ValidationFailure)error);
            } else {
                InvalidAccessor warning = new InvalidAccessor("Ignoring the field " + field.getName() + " annotated with @Property on " + clazz.getName() + ". Properties must be public or protected.", field, (ComponentType)componentType);
                context.addWarning((ValidationFailure)warning);
            }
        }
    }

    private boolean validate(Property annotation, Method method, InjectingComponentType componentType, IntrospectionContext context) {
        if (method.getParameterTypes().length != 1) {
            InvalidMethod error = new InvalidMethod("Setter methods for properties must have a single parameter: " + method, method, (ComponentType)componentType);
            context.addError((ValidationFailure)error);
            return false;
        }
        if (!Modifier.isProtected(method.getModifiers()) && !Modifier.isPublic(method.getModifiers())) {
            if (annotation.required()) {
                InvalidAccessor error = new InvalidAccessor("Invalid required property. The method " + method + " is annotated with @Property and must be public or protected.", method, (ComponentType)componentType);
                context.addError((ValidationFailure)error);
                return false;
            }
            InvalidAccessor warning = new InvalidAccessor("Ignoring " + method + " annotated with @Property. Property " + "must be public or protected.", method, (ComponentType)componentType);
            context.addWarning((ValidationFailure)warning);
            return false;
        }
        return true;
    }

    private org.fabric3.api.model.type.component.Property createDefinition(String name, boolean required, Type type, TypeMapping typeMapping) {
        org.fabric3.api.model.type.component.Property property = new org.fabric3.api.model.type.component.Property(name);
        property.setRequired(required);
        MultiplicityType multiplicityType = this.helper.introspectMultiplicity(type, typeMapping);
        property.setMany(MultiplicityType.COLLECTION == multiplicityType || MultiplicityType.DICTIONARY == multiplicityType);
        return property;
    }

    private void processSource(AccessibleObject accessible, Class<?> clazz, org.fabric3.api.model.type.component.Property property, IntrospectionContext context) {
        Source source = accessible.getAnnotation(Source.class);
        if (source != null) {
            if (!source.value().startsWith("$")) {
                InvalidAnnotation error = new InvalidAnnotation("Source attribute must specify an expression starting with '$' on:" + accessible, (AnnotatedElement)accessible, (Annotation)source, clazz);
                context.addError((ValidationFailure)error);
            } else {
                property.setSource(source.value());
                Component componentAnnotation = clazz.getAnnotation(Component.class);
                if (componentAnnotation != null) {
                    Namespace[] namespaces;
                    for (Namespace namespace : namespaces = componentAnnotation.namespaces()) {
                        String prefix = namespace.prefix();
                        String uri = namespace.uri();
                        property.addNamespace(prefix, uri);
                    }
                }
            }
        }
    }

    private void processSource(Class<?> type, Class<?> clazz, org.fabric3.api.model.type.component.Property property, IntrospectionContext context) {
        Source source = type.getAnnotation(Source.class);
        if (source != null) {
            if (!source.value().startsWith("$")) {
                InvalidAnnotation error = new InvalidAnnotation("Source attribute must specify an expression starting with '$' on:" + type, type, (Annotation)source, clazz);
                context.addError((ValidationFailure)error);
            } else {
                property.setSource(source.value());
            }
        }
    }
}

