/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.util.HashSet;
import org.fabric3.api.Role;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.ManagementInfo;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;

public class ManagementProcessor
extends AbstractAnnotationProcessor<Management> {
    public ManagementProcessor() {
        super(Management.class);
    }

    public void visitType(Management annotation, Class<?> type, InjectingComponentType componentType, IntrospectionContext context) {
        String description;
        String group;
        componentType.setManaged(true);
        String name = annotation.name();
        if (name.trim().length() == 0) {
            name = type.getSimpleName();
        }
        if ((group = annotation.group()).trim().length() == 0) {
            group = null;
        }
        if ((description = annotation.description()).trim().length() == 0) {
            description = null;
        }
        HashSet<Role> readRoles = new HashSet<Role>();
        for (String roleName : annotation.readRoles()) {
            readRoles.add(new Role(roleName));
        }
        HashSet<Role> writeRoles = new HashSet<Role>();
        for (String roleName : annotation.writeRoles()) {
            writeRoles.add(new Role(roleName));
        }
        String path = annotation.path();
        ManagementInfo info = new ManagementInfo(name, group, path, description, type.getName(), readRoles, writeRoles);
        ManagementInfo overriden = componentType.getManagementInfo();
        if (overriden != null) {
            info.getOperations().addAll(overriden.getOperations());
        }
        componentType.setManagementInfo(info);
    }
}

