/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.fabric3.api.annotation.Consumer;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.component.ConsumerDefinition;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.Signature;
import org.fabric3.introspection.java.annotation.InvalidConsumerMethod;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.TypeIntrospector;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ConsumerProcessor
extends AbstractAnnotationProcessor<Consumer> {
    private IntrospectionHelper helper;
    private List<TypeIntrospector> typeIntrospectors = Collections.emptyList();

    @Reference(required=false)
    public void setTypeIntrospectors(List<TypeIntrospector> typeIntrospectors) {
        this.typeIntrospectors = typeIntrospectors;
    }

    public ConsumerProcessor(@Reference IntrospectionHelper helper) {
        super(Consumer.class);
        this.helper = helper;
    }

    public void visitMethod(Consumer annotation, Method method, Class<?> implClass, InjectingComponentType componentType, IntrospectionContext context) {
        if (method.getParameterTypes().length > 1) {
            InvalidConsumerMethod failure = new InvalidConsumerMethod("Consumer method " + method + " has more than one parameter", method, componentType);
            context.addError((ValidationFailure)failure);
            return;
        }
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        List<DataType> types = this.introspectParameterTypes(method, typeMapping);
        String name = this.helper.getSiteName(method, annotation.value());
        Signature signature = new Signature(method);
        ConsumerDefinition definition = new ConsumerDefinition(name, types);
        int sequence = annotation.sequence();
        if (sequence < 0) {
            context.addError((ValidationFailure)new InvalidConsumerMethod("Sequence number cannot be negative: " + method, method, componentType));
        } else {
            definition.setSequence(sequence);
        }
        Class<?> clazz = method.getDeclaringClass();
        this.processSources(annotation, definition, method, clazz, context);
        componentType.add(definition, signature);
    }

    private List<DataType> introspectParameterTypes(Method method, TypeMapping typeMapping) {
        Class<?>[] physicalParameterTypes = method.getParameterTypes();
        Type[] gParamTypes = method.getGenericParameterTypes();
        ArrayList<DataType> parameterDataTypes = new ArrayList<DataType>(gParamTypes.length);
        for (int i = 0; i < gParamTypes.length; ++i) {
            Type gParamType = gParamTypes[i];
            Type logicalParamType = typeMapping.getActualType(gParamType);
            DataType dataType = this.createDataType(physicalParameterTypes[i], logicalParamType, typeMapping);
            parameterDataTypes.add(dataType);
        }
        return parameterDataTypes;
    }

    private DataType createDataType(Class<?> physicalType, Type type, TypeMapping mapping) {
        JavaType dataType;
        if (type instanceof Class) {
            dataType = new JavaType(physicalType);
        } else {
            JavaTypeInfo info = this.helper.createTypeInfo(type, mapping);
            dataType = new JavaGenericType(info);
        }
        for (TypeIntrospector introspector : this.typeIntrospectors) {
            introspector.introspect((DataType)dataType);
        }
        return dataType;
    }

    private void processSources(Consumer annotation, ConsumerDefinition definition, AccessibleObject member, Class<?> clazz, IntrospectionContext context) {
        try {
            if (annotation.sources().length > 0) {
                for (String target : annotation.sources()) {
                    definition.addSource(new URI(target));
                }
            } else if (annotation.source().length() > 0) {
                definition.addSource(new URI(annotation.source()));
            }
        }
        catch (URISyntaxException e) {
            InvalidAnnotation error = new InvalidAnnotation("Invalid consumer source on : " + clazz.getName(), (AnnotatedElement)member, (Annotation)annotation, clazz, (Exception)e);
            context.addError((ValidationFailure)error);
        }
    }
}

