/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.fabric3.api.annotation.Target;
import org.fabric3.api.annotation.Targets;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.api.model.type.ModelObject;
import org.fabric3.api.model.type.PolicyAware;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.component.ReferenceDefinition;
import org.fabric3.api.model.type.contract.ServiceContract;
import org.fabric3.api.model.type.java.InjectingComponentType;
import org.fabric3.api.model.type.java.InjectionSite;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.InvalidAnnotation;
import org.fabric3.spi.introspection.java.ReferenceProcessor;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.Reference;

public class ReferenceProcessorImpl
implements ReferenceProcessor {
    private JavaContractProcessor contractProcessor;
    private IntrospectionHelper helper;
    private PolicyAnnotationProcessor policyProcessor;

    @Reference
    public void setPolicyProcessor(PolicyAnnotationProcessor processor) {
        this.policyProcessor = processor;
    }

    public ReferenceProcessorImpl(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        this.contractProcessor = contractProcessor;
        this.helper = helper;
    }

    public void addDefinition(Field field, String name, boolean required, Class<?> clazz, InjectingComponentType componentType, IntrospectionContext context) {
        name = this.helper.getSiteName(field, name);
        Type type = field.getGenericType();
        FieldInjectionSite site = new FieldInjectionSite(field);
        Annotation[] annotations = field.getAnnotations();
        ReferenceDefinition definition = this.createDefinition(name, required, type, clazz, annotations, componentType, context);
        componentType.add(definition, (InjectionSite)site);
        this.addTargets(field, field, context, definition);
    }

    public void addDefinition(Method method, String name, boolean required, Class<?> clazz, InjectingComponentType componentType, IntrospectionContext context) {
        name = this.helper.getSiteName(method, name);
        Type type = this.helper.getGenericType(method);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        Annotation[] annotations = method.getAnnotations();
        ReferenceDefinition definition = this.createDefinition(name, required, type, clazz, annotations, componentType, context);
        this.addTargets(method, method, context, definition);
        componentType.add(definition, (InjectionSite)site);
    }

    public void addDefinition(Constructor constructor, String name, int index, boolean required, Class<?> clazz, InjectingComponentType componentType, IntrospectionContext context) {
        name = this.helper.getSiteName(constructor, index, name);
        Type type = this.helper.getGenericType(constructor, index);
        ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, index);
        Annotation[] annotations = constructor.getParameterAnnotations()[index];
        ReferenceDefinition definition = this.createDefinition(name, required, type, clazz, annotations, componentType, context);
        componentType.add(definition, (InjectionSite)site);
        this.addTargets(constructor, constructor, context, definition);
    }

    private ReferenceDefinition createDefinition(String name, boolean required, Type type, Class<?> implClass, Annotation[] annotations, InjectingComponentType componentType, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class baseType = this.helper.getBaseType(type, typeMapping);
        JavaServiceContract contract = this.contractProcessor.introspect(baseType, implClass, context, new ModelObject[]{componentType});
        ReferenceDefinition definition = new ReferenceDefinition(name, (ServiceContract)contract);
        this.helper.processMultiplicity(definition, required, type, typeMapping);
        if (this.policyProcessor != null) {
            for (Annotation annotation : annotations) {
                this.policyProcessor.process(annotation, (PolicyAware)definition, context);
            }
        }
        return definition;
    }

    private void addTargets(AccessibleObject accessibleObject, Member member, IntrospectionContext context, ReferenceDefinition definition) {
        Targets targetsAnnotation = accessibleObject.getAnnotation(Targets.class);
        if (targetsAnnotation != null) {
            Multiplicity multiplicity = definition.getMultiplicity();
            if (multiplicity != Multiplicity.ONE_N && multiplicity != Multiplicity.ZERO_N) {
                Class<?> clazz = member.getDeclaringClass();
                String name = member.getName();
                InvalidAnnotation error = new InvalidAnnotation("Reference is not a multiplicity: " + name, (AnnotatedElement)accessibleObject, (Annotation)targetsAnnotation, clazz);
                context.addError((ValidationFailure)error);
                return;
            }
            for (String value : targetsAnnotation.value()) {
                org.fabric3.api.model.type.component.Target target = this.parseTarget(value, (Annotation)targetsAnnotation, accessibleObject, member, context);
                if (target == null) continue;
                definition.addTarget(target);
            }
        } else {
            org.fabric3.api.model.type.component.Target target;
            Target targetAnnotation = accessibleObject.getAnnotation(Target.class);
            if (targetAnnotation != null && (target = this.parseTarget(targetAnnotation.value(), (Annotation)targetAnnotation, accessibleObject, member, context)) != null) {
                definition.addTarget(target);
            }
        }
    }

    private org.fabric3.api.model.type.component.Target parseTarget(String target, Annotation annotation, AccessibleObject accessibleObject, Member member, IntrospectionContext context) {
        String[] tokens = target.split("/");
        if (tokens.length == 1) {
            return new org.fabric3.api.model.type.component.Target(tokens[0]);
        }
        if (tokens.length == 2) {
            return new org.fabric3.api.model.type.component.Target(tokens[0], tokens[1]);
        }
        if (tokens.length == 3) {
            return new org.fabric3.api.model.type.component.Target(tokens[0], tokens[1], tokens[2]);
        }
        Class<?> clazz = member.getDeclaringClass();
        String name = member.getName();
        InvalidAnnotation error = new InvalidAnnotation("Invalid target format: " + target + " on " + name, (AnnotatedElement)accessibleObject, annotation, clazz);
        context.addError((ValidationFailure)error);
        return null;
    }
}

