/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import org.fabric3.api.model.type.component.AbstractService;
import org.fabric3.api.model.type.component.Multiplicity;
import org.fabric3.api.model.type.component.ReferenceDefinition;
import org.fabric3.api.model.type.contract.DataType;
import org.fabric3.api.model.type.contract.Operation;
import org.fabric3.api.model.type.java.InjectableType;
import org.fabric3.api.model.type.java.Signature;
import org.fabric3.spi.introspection.ImplementationNotFoundException;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.MultiplicityType;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaType;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.oasisopen.sca.ComponentContext;
import org.oasisopen.sca.RequestContext;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.Callback;
import org.oasisopen.sca.annotation.Constructor;
import org.oasisopen.sca.annotation.Remotable;
import org.oasisopen.sca.annotation.Service;

public class DefaultIntrospectionHelper
implements IntrospectionHelper {
    private static final Set<Class<?>> WRAPPERS = new HashSet();

    public Class<?> loadClass(String name, ClassLoader cl) throws ImplementationNotFoundException {
        Thread thread = Thread.currentThread();
        ClassLoader oldCL = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(cl);
            Class<?> clazz = Class.forName(name, true, cl);
            return clazz;
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            throw new ImplementationNotFoundException(name, e);
        }
        finally {
            thread.setContextClassLoader(oldCL);
        }
    }

    public String getSiteName(Field field, String override) {
        if (override != null && override.length() != 0) {
            return override;
        }
        return field.getName();
    }

    public String getSiteName(Method setter, String override) {
        if (override != null && override.length() != 0) {
            return override;
        }
        String name = setter.getName();
        if (name.length() > 3 && name.startsWith("set")) {
            return Character.toLowerCase(name.charAt(3)) + name.substring(4);
        }
        return name;
    }

    public String getSiteName(java.lang.reflect.Constructor<?> constructor, int index, String override) {
        String[] names;
        if (override != null && override.length() != 0) {
            return override;
        }
        Constructor oasisAnnotation = constructor.getAnnotation(Constructor.class);
        if (oasisAnnotation != null && ((names = oasisAnnotation.value()).length != 1 || names[0].length() != 0)) {
            return names[index];
        }
        return constructor.getDeclaringClass().getSimpleName() + "[" + index + ']';
    }

    public Type getGenericType(Method setter) {
        return this.getGenericType(setter, 0);
    }

    public Type getGenericType(Method method, int index) {
        return method.getGenericParameterTypes()[index];
    }

    public Type getGenericType(java.lang.reflect.Constructor<?> constructor, int index) {
        return constructor.getGenericParameterTypes()[index];
    }

    public Class<?> getBaseType(Type type, TypeMapping typeMapping) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            if (clazz.isArray()) {
                return clazz.getComponentType();
            }
            if (WRAPPERS.contains(clazz) || Map.class.equals((Object)clazz)) {
                return Object.class;
            }
            return clazz;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class clazz = (Class)parameterizedType.getRawType();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (WRAPPERS.contains(clazz)) {
                return typeMapping.getRawType(typeArguments[0]);
            }
            if (Map.class.equals((Object)clazz)) {
                return typeMapping.getRawType(typeArguments[1]);
            }
            return clazz;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            return typeMapping.getRawType(arrayType.getGenericComponentType());
        }
        throw new AssertionError((Object)("Unknown Type: " + type));
    }

    public void processMultiplicity(ReferenceDefinition definition, boolean required, Type type, TypeMapping typeMapping) {
        MultiplicityType multiplicityType = this.introspectMultiplicity(type, typeMapping);
        if (MultiplicityType.COLLECTION == multiplicityType) {
            Multiplicity multiplicity = required ? Multiplicity.ONE_N : Multiplicity.ZERO_N;
            definition.setMultiplicity(multiplicity);
        } else if (MultiplicityType.DICTIONARY == multiplicityType) {
            Multiplicity multiplicity = required ? Multiplicity.ONE_N : Multiplicity.ZERO_N;
            definition.setMultiplicity(multiplicity);
            DataType keyType = this.getKeyType(type, typeMapping);
            definition.setKeyed(true);
            definition.setKeyDataType(keyType);
        } else {
            Multiplicity multiplicity = required ? Multiplicity.ONE_ONE : Multiplicity.ZERO_ONE;
            definition.setMultiplicity(multiplicity);
        }
    }

    public MultiplicityType introspectMultiplicity(Type type, TypeMapping typeMapping) {
        if (type instanceof GenericArrayType) {
            return MultiplicityType.COLLECTION;
        }
        Class rawType = typeMapping.getRawType(type);
        if (rawType.isArray() || WRAPPERS.contains(rawType)) {
            return MultiplicityType.COLLECTION;
        }
        if (Map.class.isAssignableFrom(rawType)) {
            return MultiplicityType.DICTIONARY;
        }
        return MultiplicityType.SINGLE;
    }

    public InjectableType inferType(Type type, TypeMapping typeMapping) {
        Class<?> baseType = this.getBaseType(type, typeMapping);
        Class rawType = typeMapping.getRawType(baseType);
        if (!rawType.isInterface()) {
            return InjectableType.PROPERTY;
        }
        if (ComponentContext.class.isAssignableFrom(rawType) || RequestContext.class.isAssignableFrom(rawType)) {
            return InjectableType.CONTEXT;
        }
        if (this.isAnnotationPresent(rawType, Remotable.class) || this.isAnnotationPresent(rawType, Service.class)) {
            return InjectableType.REFERENCE;
        }
        if (this.isAnnotationPresent(rawType, Callback.class)) {
            return InjectableType.CALLBACK;
        }
        return InjectableType.PROPERTY;
    }

    public boolean isAnnotationPresent(Class<?> type, Class<? extends Annotation> annotationType) {
        Class<?>[] interfaces;
        if (type.isAnnotationPresent(annotationType)) {
            return true;
        }
        for (Class<?> superInterface : interfaces = type.getInterfaces()) {
            if (!this.isAnnotationPresent(superInterface, annotationType)) continue;
            return true;
        }
        return false;
    }

    public Set<Class<?>> getImplementedInterfaces(Class<?> type) {
        HashSet interfaces = new HashSet();
        while (type != null) {
            block1: for (Class<?> current : type.getInterfaces()) {
                for (Class clazz : interfaces) {
                    if (!current.isAssignableFrom(clazz)) continue;
                    continue block1;
                }
                interfaces.add(current);
            }
            type = type.getSuperclass();
        }
        return interfaces;
    }

    public Set<Method> getInjectionMethods(Class<?> type, Collection<AbstractService> services) {
        Set<Signature> exclude = this.getOperations(services);
        HashSet<Method> methods = new HashSet<Method>();
        while (type != null) {
            for (Method method : type.getDeclaredMethods()) {
                Signature signature;
                int modifiers = method.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isAbstract(modifiers) || !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || !this.isSetter(method) || exclude.contains(signature = new Signature(method))) continue;
                exclude.add(signature);
                methods.add(method);
            }
            type = type.getSuperclass();
        }
        return methods;
    }

    private boolean isSetter(Method method) {
        if (!Void.TYPE.equals(method.getReturnType())) {
            return false;
        }
        if (method.getParameterTypes().length != 1) {
            return false;
        }
        String name = method.getName();
        return name.length() >= 4 && name.startsWith("set");
    }

    private Set<Signature> getOperations(Collection<AbstractService> services) {
        HashSet<Signature> operations = new HashSet<Signature>();
        for (AbstractService definition : services) {
            List ops = definition.getServiceContract().getOperations();
            for (Operation operation : ops) {
                String name = operation.getName();
                List inputTypes = operation.getInputTypes();
                ArrayList<String> paramTypes = new ArrayList<String>(inputTypes.size());
                for (DataType inputType : inputTypes) {
                    paramTypes.add(inputType.getType().getName());
                }
                operations.add(new Signature(name, paramTypes));
            }
        }
        return operations;
    }

    public Set<Field> getInjectionFields(Class<?> type) {
        HashSet<Field> fields = new HashSet<Field>();
        HashSet<String> exclude = new HashSet<String>();
        while (type != null) {
            for (Field field : type.getDeclaredFields()) {
                String name;
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers) || !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) || exclude.contains(name = field.getName())) continue;
                exclude.add(name);
                fields.add(field);
            }
            type = type.getSuperclass();
        }
        return fields;
    }

    public void resolveTypeParameters(Class<?> type, TypeMapping typeMapping) {
        while (type != null) {
            this.addTypeBindings(type.getGenericSuperclass(), typeMapping);
            for (Type interfaceType : type.getGenericInterfaces()) {
                this.addTypeBindings(interfaceType, typeMapping);
            }
            type = type.getSuperclass();
        }
    }

    public JavaTypeInfo createTypeInfo(Type type, TypeMapping typeMapping) {
        if (type instanceof Class) {
            return new JavaTypeInfo((Class)type);
        }
        if (type instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)type;
            Type actual = typeMapping.getActualType((Type)typeVariable);
            if (actual instanceof TypeVariable) {
                return new JavaTypeInfo(typeMapping.getRawType((Type)typeVariable));
            }
            return this.createTypeInfo(actual, typeMapping);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            ArrayList<JavaTypeInfo> infos = new ArrayList<JavaTypeInfo>();
            for (Type arg : parameterizedType.getActualTypeArguments()) {
                Type argActual = typeMapping.getActualType(arg);
                JavaTypeInfo argInfo = this.createTypeInfo(argActual, typeMapping);
                infos.add(argInfo);
            }
            Class rawType = typeMapping.getRawType(parameterizedType.getRawType());
            return new JavaTypeInfo(rawType, infos);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            Class componentType = typeMapping.getRawType(arrayType.getGenericComponentType());
            return new JavaTypeInfo(Array.newInstance(componentType, 0).getClass());
        }
        if (type instanceof WildcardType) {
            WildcardType wildcardType = (WildcardType)type;
            Type actual = typeMapping.getActualType((Type)wildcardType);
            if (actual instanceof WildcardType) {
                return new JavaTypeInfo(typeMapping.getRawType((Type)wildcardType));
            }
            return this.createTypeInfo(actual, typeMapping);
        }
        throw new AssertionError();
    }

    private void addTypeBindings(Type type1, TypeMapping mapping) {
        if (type1 instanceof ParameterizedType) {
            ParameterizedType type = (ParameterizedType)type1;
            Class boundType = (Class)type.getRawType();
            TypeVariable<Class<T>>[] typeVariables = boundType.getTypeParameters();
            Type[] arguments = type.getActualTypeArguments();
            for (int i = 0; i < typeVariables.length; ++i) {
                mapping.addMapping(typeVariables[i], arguments[i]);
            }
        }
    }

    private DataType getKeyType(Type type, TypeMapping typeMapping) {
        Type actualType = typeMapping.getActualType(type);
        if (actualType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)actualType;
            Type actualKeyType = typeMapping.getActualType(parameterizedType.getActualTypeArguments()[0]);
            if (actualKeyType instanceof Class) {
                return new JavaType((Class)actualKeyType);
            }
            return new JavaGenericType(this.createTypeInfo(actualKeyType, typeMapping));
        }
        if (actualType instanceof Map) {
            return new JavaType(Object.class);
        }
        throw new IllegalArgumentException("Type not a Map: " + type);
    }

    static {
        WRAPPERS.add(Collection.class);
        WRAPPERS.add(List.class);
        WRAPPERS.add(Queue.class);
        WRAPPERS.add(Set.class);
        WRAPPERS.add(SortedSet.class);
        WRAPPERS.add(ServiceReference.class);
    }
}

