/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.wire;

import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jms.BytesMessage;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import javax.jms.TextMessage;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.binding.jms.model.CorrelationScheme;
import org.fabric3.binding.jms.runtime.common.ListenerMonitor;
import org.fabric3.binding.jms.runtime.wire.InvocationChainHolder;
import org.fabric3.binding.jms.runtime.wire.JmsBadMessageException;
import org.fabric3.binding.jms.runtime.wire.MessageHelper;
import org.fabric3.binding.jms.runtime.wire.WireHolder;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.provision.PayloadType;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.fabric3.spi.container.binding.handler.BindingHandler;
import org.fabric3.spi.container.invocation.CallbackReferenceSerializer;
import org.fabric3.spi.container.invocation.Message;
import org.fabric3.spi.container.invocation.MessageCache;
import org.fabric3.spi.container.invocation.WorkContext;
import org.fabric3.spi.container.invocation.WorkContextCache;
import org.fabric3.spi.container.wire.Interceptor;
import org.fabric3.spi.xml.XMLFactory;

public class ServiceListener
implements MessageListener {
    private WireHolder wireHolder;
    private Map<String, InvocationChainHolder> invocationChainMap;
    private InvocationChainHolder onMessageHolder;
    private Destination defaultResponseDestination;
    private ConnectionFactory responseFactory;
    private SessionType sessionType;
    private ClassLoader classLoader;
    private ListenerMonitor monitor;
    private XMLFactory xmlFactory;
    private XMLInputFactory xmlInputFactory;
    private List<BindingHandler<javax.jms.Message>> handlers;

    public ServiceListener(WireHolder wireHolder, Destination defaultResponseDestination, ConnectionFactory responseFactory, SessionType sessionType, ClassLoader classLoader, XMLFactory xmlFactory, List<BindingHandler<javax.jms.Message>> handlers, ListenerMonitor monitor) {
        this.wireHolder = wireHolder;
        this.defaultResponseDestination = defaultResponseDestination;
        this.responseFactory = responseFactory;
        this.sessionType = sessionType;
        this.classLoader = classLoader;
        this.xmlFactory = xmlFactory;
        this.handlers = handlers;
        this.monitor = monitor;
        this.invocationChainMap = new HashMap<String, InvocationChainHolder>();
        for (InvocationChainHolder chainHolder : wireHolder.getInvocationChains()) {
            String name = chainHolder.getChain().getPhysicalOperation().getName();
            if ("onMessage".equals(name)) {
                this.onMessageHolder = chainHolder;
            }
            this.invocationChainMap.put(name, chainHolder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onMessage(javax.jms.Message request) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.classLoader);
            InvocationChainHolder holder = this.getHolder(request);
            Interceptor interceptor = holder.getChain().getHeadInterceptor();
            boolean oneWay = holder.getChain().getPhysicalOperation().isOneWay();
            OperationPayloadTypes payloadTypes = holder.getPayloadTypes();
            PayloadType inputType = payloadTypes.getInputType();
            Object[] payload = MessageHelper.getPayload(request, inputType);
            switch (inputType) {
                case OBJECT: {
                    if (payload != null && !payload.getClass().isArray()) {
                        payload = new Object[]{payload};
                    }
                    this.invoke(request, interceptor, payload, payloadTypes, oneWay, this.sessionType);
                    return;
                }
                case TEXT: {
                    payload = new Object[]{payload};
                    this.invoke(request, interceptor, payload, payloadTypes, oneWay, this.sessionType);
                    return;
                }
                case STREAM: {
                    throw new UnsupportedOperationException();
                }
                default: {
                    payload = new Object[]{payload};
                    this.invoke(request, interceptor, payload, payloadTypes, oneWay, this.sessionType);
                    return;
                }
            }
        }
        catch (JMSException | JmsBadMessageException e) {
            this.monitor.redeliveryError((Throwable)e);
            return;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invoke(javax.jms.Message request, Interceptor interceptor, Object payload, OperationPayloadTypes payloadTypes, boolean oneWay, SessionType sessionType) throws JMSException, JmsBadMessageException {
        WorkContext workContext = this.setWorkContext(request);
        Message inMessage = MessageCache.getAndResetMessage();
        inMessage.setWorkContext(workContext);
        inMessage.setBody(payload);
        this.applyHandlers(request, inMessage);
        Message outMessage = interceptor.invoke(inMessage);
        if (oneWay) {
            inMessage.reset();
            return;
        }
        Connection connection = null;
        Session responseSession = null;
        try {
            connection = this.responseFactory.createConnection();
            responseSession = SessionType.GLOBAL_TRANSACTED == sessionType ? connection.createSession(true, 0) : connection.createSession(false, 1);
            Object responsePayload = outMessage.getBody();
            PayloadType returnType = outMessage.isFault() ? payloadTypes.getFaultType() : payloadTypes.getOutputType();
            javax.jms.Message response = this.createMessage(responsePayload, responseSession, returnType);
            this.sendResponse(request, responseSession, outMessage, response);
        }
        finally {
            inMessage.reset();
            workContext.reset();
            if (responseSession != null) {
                responseSession.close();
            }
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void sendResponse(javax.jms.Message request, Session responseSession, Message outMessage, javax.jms.Message response) throws JMSException, JmsBadMessageException {
        MessageProducer producer;
        CorrelationScheme correlationScheme = this.wireHolder.getCorrelationScheme();
        switch (correlationScheme) {
            case CORRELATION_ID: {
                response.setJMSCorrelationID(request.getJMSCorrelationID());
                break;
            }
            case MESSAGE_ID: {
                response.setJMSCorrelationID(request.getJMSMessageID());
            }
        }
        if (outMessage.isFault()) {
            response.setBooleanProperty("f3Fault", true);
        }
        if (request.getJMSReplyTo() != null) {
            producer = responseSession.createProducer(request.getJMSReplyTo());
        } else {
            if (this.defaultResponseDestination == null) {
                throw new JmsBadMessageException("JMSReplyTo must be set as no response destination was configured on the service");
            }
            producer = responseSession.createProducer(this.defaultResponseDestination);
        }
        producer.send(response);
    }

    private javax.jms.Message createMessage(Object payload, Session session, PayloadType payloadType) throws JMSException {
        switch (payloadType) {
            case STREAM: {
                throw new UnsupportedOperationException("Stream message not yet supported");
            }
            case TEXT: {
                if (payload != null && !(payload instanceof String)) {
                    throw new IllegalArgumentException("Response payload is not a string: " + payload);
                }
                return session.createTextMessage((String)payload);
            }
            case OBJECT: {
                if (payload != null && !(payload instanceof Serializable)) {
                    throw new IllegalArgumentException("Response payload is not serializable: " + payload);
                }
                return session.createObjectMessage((Serializable)payload);
            }
        }
        return MessageHelper.createBytesMessage(session, payload, payloadType);
    }

    private InvocationChainHolder getHolder(javax.jms.Message message) throws JmsBadMessageException, JMSException {
        List<InvocationChainHolder> chainHolders = this.wireHolder.getInvocationChains();
        if (chainHolders.size() == 1) {
            return chainHolders.get(0);
        }
        if (this.onMessageHolder != null) {
            return this.onMessageHolder;
        }
        String opName = message.getStringProperty("scaOperationName");
        if (opName != null) {
            InvocationChainHolder chainHolder = this.invocationChainMap.get(opName);
            if (chainHolder == null) {
                throw new JmsBadMessageException("Unable to match operation on the service contract: " + opName);
            }
            return chainHolder;
        }
        if (message instanceof TextMessage) {
            TextMessage textMessage = (TextMessage)message;
            String payload = textMessage.getText();
            return this.getHolderBasedOnElementName(payload.getBytes());
        }
        if (message instanceof BytesMessage) {
            BytesMessage bytesMessage = (BytesMessage)message;
            byte[] payload = new byte[(int)bytesMessage.getBodyLength()];
            bytesMessage.readBytes(payload);
            return this.getHolderBasedOnElementName(payload);
        }
        throw new JmsBadMessageException("Unable to match operation on the service contract");
    }

    private InvocationChainHolder getHolderBasedOnElementName(byte[] payload) throws JmsBadMessageException {
        if (this.xmlInputFactory == null) {
            this.xmlInputFactory = this.xmlFactory.newInputFactoryInstance();
        }
        try {
            XMLStreamReader reader = this.xmlInputFactory.createXMLStreamReader(new ByteArrayInputStream(payload));
            reader.nextTag();
            String name = reader.getName().getLocalPart();
            InvocationChainHolder chainHolder = this.invocationChainMap.get(name);
            if (chainHolder == null) {
                throw new JmsBadMessageException("Unable to match operation on for name: " + name);
            }
            return chainHolder;
        }
        catch (XMLStreamException e) {
            throw new JmsBadMessageException("Unable to process message", e);
        }
    }

    private WorkContext setWorkContext(javax.jms.Message request) throws JmsBadMessageException {
        try {
            WorkContext workContext = WorkContextCache.getAndResetThreadWorkContext();
            String encoded = request.getStringProperty("f3Context");
            if (encoded == null) {
                return workContext;
            }
            List stack = CallbackReferenceSerializer.deserialize((String)encoded);
            workContext.addCallbackReferences(stack);
            return workContext;
        }
        catch (JMSException e) {
            throw new JmsBadMessageException("Error deserializing callback references", e);
        }
    }

    private void applyHandlers(javax.jms.Message request, Message inMessage) {
        if (this.handlers != null) {
            for (BindingHandler<javax.jms.Message> handler : this.handlers) {
                handler.handleInbound((Object)request, inMessage);
            }
        }
    }
}

