/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.wire;

import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.fabric3.binding.jms.runtime.wire.JmsBadMessageException;
import org.fabric3.binding.jms.spi.provision.PayloadType;

public class MessageHelper {
    public static Message createBytesMessage(Session session, Object payload, PayloadType payloadType) throws JMSException {
        BytesMessage message = session.createBytesMessage();
        switch (payloadType) {
            case BOOLEAN: {
                message.writeBoolean(((Boolean)payload).booleanValue());
                break;
            }
            case BYTE: {
                message.writeByte(((Byte)payload).byteValue());
                break;
            }
            case CHARACTER: {
                message.writeChar(((Character)payload).charValue());
                break;
            }
            case DOUBLE: {
                message.writeDouble(((Double)payload).doubleValue());
                break;
            }
            case FLOAT: {
                message.writeFloat(((Float)payload).floatValue());
                break;
            }
            case INTEGER: {
                message.writeInt(((Integer)payload).intValue());
                break;
            }
            case LONG: {
                message.writeLong(((Long)payload).longValue());
                break;
            }
            case SHORT: {
                message.writeShort(((Short)payload).shortValue());
            }
        }
        return message;
    }

    public static Object getPayload(Message message, PayloadType payloadType) throws JMSException, JmsBadMessageException {
        Object payload;
        switch (payloadType) {
            case OBJECT: {
                if (!(message instanceof ObjectMessage)) {
                    throw new JmsBadMessageException("Invalid message type. Expecting ObjectMessage");
                }
                ObjectMessage objectMessage = (ObjectMessage)message;
                payload = objectMessage.getObject();
                break;
            }
            case STREAM: {
                throw new UnsupportedOperationException("Stream message not yet supported");
            }
            case TEXT: {
                if (!(message instanceof TextMessage)) {
                    throw new JmsBadMessageException("Invalid message type. Expecting TextMessage");
                }
                TextMessage textMessage = (TextMessage)message;
                payload = textMessage.getText();
                break;
            }
            case BOOLEAN: {
                if (!(message instanceof BytesMessage)) {
                    throw new JmsBadMessageException("Invalid message type. Expecting BytesMessage");
                }
                BytesMessage booleanMessage = (BytesMessage)message;
                return booleanMessage.readBoolean();
            }
            case BYTE: {
                if (!(message instanceof BytesMessage)) {
                    throw new JmsBadMessageException("Invalid message type. Expecting BytesMessage");
                }
                BytesMessage bytesMessage = (BytesMessage)message;
                return bytesMessage.readByte();
            }
            case CHARACTER: {
                if (!(message instanceof BytesMessage)) {
                    throw new JmsBadMessageException("Invalid message type. Expecting BytesMessage");
                }
                BytesMessage charMessage = (BytesMessage)message;
                return Character.valueOf(charMessage.readChar());
            }
            case DOUBLE: {
                if (!(message instanceof BytesMessage)) {
                    throw new JmsBadMessageException("Invalid message type. Expecting BytesMessage");
                }
                BytesMessage doubleMessage = (BytesMessage)message;
                return doubleMessage.readDouble();
            }
            case FLOAT: {
                if (!(message instanceof BytesMessage)) {
                    throw new JmsBadMessageException("Invalid message type. Expecting BytesMessage");
                }
                BytesMessage floatMessage = (BytesMessage)message;
                return Float.valueOf(floatMessage.readFloat());
            }
            case INTEGER: {
                if (!(message instanceof BytesMessage)) {
                    throw new JmsBadMessageException("Invalid message type. Expecting BytesMessage");
                }
                BytesMessage intMessage = (BytesMessage)message;
                return intMessage.readInt();
            }
            case LONG: {
                if (!(message instanceof BytesMessage)) {
                    throw new JmsBadMessageException("Invalid message type. Expecting BytesMessage");
                }
                BytesMessage longMessage = (BytesMessage)message;
                return longMessage.readLong();
            }
            case SHORT: {
                if (!(message instanceof BytesMessage)) {
                    throw new JmsBadMessageException("Invalid message type. Expecting BytesMessage");
                }
                BytesMessage shortMessage = (BytesMessage)message;
                return shortMessage.readShort();
            }
            default: {
                throw new UnsupportedOperationException("Unsupported message type: " + message);
            }
        }
        return payload;
    }

    private MessageHelper() {
    }
}

