/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.destination;

import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.fabric3.api.binding.jms.model.DestinationDefinition;
import org.fabric3.binding.jms.runtime.resolver.DestinationStrategy;
import org.fabric3.binding.jms.spi.runtime.provider.DestinationResolver;
import org.fabric3.binding.jms.spi.runtime.provider.JmsResolutionException;
import org.oasisopen.sca.annotation.Reference;

public class NeverDestinationStrategy
implements DestinationStrategy {
    private List<DestinationResolver> resolvers;

    @Reference(required=false)
    public void setResolvers(List<DestinationResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public Destination getDestination(DestinationDefinition definition, ConnectionFactory factory) throws JmsResolutionException {
        for (DestinationResolver resolver : this.resolvers) {
            Destination destination = resolver.resolve(definition);
            if (destination == null) continue;
            return destination;
        }
        throw new JmsResolutionException("Destination not found: " + definition.getName());
    }
}

