/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.destination;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import org.fabric3.api.binding.jms.model.DestinationDefinition;
import org.fabric3.binding.jms.runtime.common.JmsHelper;
import org.fabric3.binding.jms.runtime.resolver.DestinationStrategy;
import org.fabric3.binding.jms.spi.runtime.provider.JmsResolutionException;

public class AlwaysDestinationStrategy
implements DestinationStrategy {
    @Override
    public Destination getDestination(DestinationDefinition definition, ConnectionFactory factory) throws JmsResolutionException {
        Connection connection = null;
        String name = definition.getName();
        try {
            connection = factory.createConnection();
            connection.start();
            switch (definition.geType()) {
                case QUEUE: {
                    QueueConnection qc = (QueueConnection)connection;
                    Queue queue = qc.createQueueSession(false, 1).createQueue(name);
                    return queue;
                }
                case TOPIC: {
                    TopicConnection tc = (TopicConnection)connection;
                    Topic topic = tc.createTopicSession(false, 1).createTopic(name);
                    return topic;
                }
            }
            try {
                throw new IllegalArgumentException("Unknown destination type for:" + name);
            }
            catch (JMSException ex) {
                throw new JmsResolutionException("Unable to create destination:" + name, ex);
            }
        }
        finally {
            if (connection != null) {
                try {
                    connection.stop();
                }
                catch (JMSException e) {
                    e.printStackTrace();
                }
            }
            JmsHelper.closeQuietly(connection);
        }
    }
}

