/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.connectionfactory;

import java.util.Iterator;
import java.util.List;
import javax.jms.ConnectionFactory;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.spi.runtime.manager.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.manager.FactoryRegistrationException;
import org.fabric3.binding.jms.spi.runtime.provider.ConnectionFactoryResolver;
import org.fabric3.binding.jms.spi.runtime.provider.JmsResolutionException;
import org.oasisopen.sca.annotation.Reference;

public class NeverConnectionFactoryStrategy
implements ConnectionFactoryStrategy {
    private ConnectionFactoryManager manager;
    private List<ConnectionFactoryResolver> resolvers;

    public NeverConnectionFactoryStrategy(@Reference ConnectionFactoryManager manager) {
        this.manager = manager;
    }

    @Reference(required=false)
    public void setResolvers(List<ConnectionFactoryResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public ConnectionFactory getConnectionFactory(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        String name = definition.getName();
        try {
            ConnectionFactoryResolver resolver;
            ConnectionFactory factory = this.manager.get(name);
            if (factory != null) {
                return factory;
            }
            Iterator<ConnectionFactoryResolver> i$ = this.resolvers.iterator();
            while (i$.hasNext() && (factory = (resolver = i$.next()).resolve(definition)) == null) {
            }
            return this.manager.register(name, factory, definition.getProperties());
        }
        catch (FactoryRegistrationException e) {
            throw new JmsResolutionException("Error resolving connection factory: " + name, (Throwable)((Object)e));
        }
    }

    @Override
    public void release(ConnectionFactoryDefinition definition) throws JmsResolutionException {
    }
}

