/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.connectionfactory;

import java.util.List;
import javax.jms.ConnectionFactory;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.runtime.resolver.connectionfactory.AlwaysConnectionFactoryStrategy;
import org.fabric3.binding.jms.spi.runtime.connection.ConnectionFactoryCreatorRegistry;
import org.fabric3.binding.jms.spi.runtime.manager.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.provider.ConnectionFactoryResolver;
import org.fabric3.binding.jms.spi.runtime.provider.JmsResolutionException;
import org.oasisopen.sca.annotation.Reference;

public class IfNotExistConnectionFactoryStrategy
implements ConnectionFactoryStrategy {
    private AlwaysConnectionFactoryStrategy always;
    private ConnectionFactoryManager manager;
    private List<ConnectionFactoryResolver> resolvers;

    public IfNotExistConnectionFactoryStrategy(@Reference ConnectionFactoryCreatorRegistry creatorRegistry, @Reference ConnectionFactoryManager manager) {
        this.always = new AlwaysConnectionFactoryStrategy(creatorRegistry, manager);
        this.manager = manager;
    }

    @Reference(required=false)
    public void setResolvers(List<ConnectionFactoryResolver> resolvers) {
        this.resolvers = resolvers;
    }

    @Override
    public ConnectionFactory getConnectionFactory(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        String name = definition.getName();
        if (name != null) {
            ConnectionFactory factory = this.manager.get(name);
            if (factory != null) {
                return factory;
            }
            for (ConnectionFactoryResolver resolver : this.resolvers) {
                factory = resolver.resolve(definition);
                if (factory == null) continue;
                return factory;
            }
        }
        return this.always.getConnectionFactory(definition);
    }

    @Override
    public void release(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        this.always.release(definition);
    }
}

