/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.resolver.connectionfactory;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jms.ConnectionFactory;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.binding.jms.runtime.resolver.ConnectionFactoryStrategy;
import org.fabric3.binding.jms.spi.runtime.connection.ConnectionFactoryCreatorRegistry;
import org.fabric3.binding.jms.spi.runtime.manager.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.manager.FactoryRegistrationException;
import org.fabric3.binding.jms.spi.runtime.provider.JmsResolutionException;
import org.oasisopen.sca.annotation.Reference;

public class AlwaysConnectionFactoryStrategy
implements ConnectionFactoryStrategy {
    private ConnectionFactoryCreatorRegistry creatorRegistry;
    private ConnectionFactoryManager manager;
    private Set<String> created = new HashSet<String>();

    public AlwaysConnectionFactoryStrategy(@Reference ConnectionFactoryCreatorRegistry creatorRegistry, @Reference ConnectionFactoryManager manager) {
        this.creatorRegistry = creatorRegistry;
        this.manager = manager;
    }

    @Override
    public ConnectionFactory getConnectionFactory(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        try {
            Map properties = definition.getProperties();
            String className = (String)properties.get("class");
            ConnectionFactory factory = this.instantiate(className, properties);
            String name = definition.getName();
            this.created.add(name);
            return this.manager.register(name, factory, definition.getProperties());
        }
        catch (FactoryRegistrationException e) {
            throw new JmsResolutionException((Throwable)((Object)e));
        }
    }

    @Override
    public void release(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        try {
            String name = definition.getName();
            if (this.created.remove(name)) {
                ConnectionFactory factory = this.manager.unregister(name);
                if (factory == null) {
                    throw new JmsResolutionException("Connection factory not found: " + name);
                }
                this.creatorRegistry.release(factory);
            }
        }
        catch (FactoryRegistrationException e) {
            throw new JmsResolutionException((Throwable)((Object)e));
        }
    }

    private ConnectionFactory instantiate(String className, Map<String, String> props) throws JmsResolutionException {
        try {
            ConnectionFactory factory = (ConnectionFactory)Class.forName(className).newInstance();
            for (PropertyDescriptor pd : Introspector.getBeanInfo(factory.getClass()).getPropertyDescriptors()) {
                String propName = pd.getName();
                String propValue = props.get(propName);
                Method writeMethod = pd.getWriteMethod();
                if (propValue == null || writeMethod == null) continue;
                writeMethod.invoke((Object)factory, propValue);
            }
            return factory;
        }
        catch (IntrospectionException | ClassNotFoundException | IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new JmsResolutionException("Unable to create connection factory: " + className, e);
        }
    }
}

