/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.jndi;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.naming.NamingException;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.DestinationDefinition;
import org.fabric3.binding.jms.spi.runtime.manager.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.manager.FactoryRegistrationException;
import org.fabric3.binding.jms.spi.runtime.provider.ConnectionFactoryResolver;
import org.fabric3.binding.jms.spi.runtime.provider.DestinationResolver;
import org.fabric3.binding.jms.spi.runtime.provider.JmsResolutionException;
import org.fabric3.jndi.spi.JndiContextManager;
import org.oasisopen.sca.annotation.Reference;

public class JndiAdministeredObjectResolver
implements ConnectionFactoryResolver,
DestinationResolver {
    private JndiContextManager contextManager;
    private ConnectionFactoryManager factoryManager;

    public JndiAdministeredObjectResolver(@Reference JndiContextManager contextManager, @Reference ConnectionFactoryManager factoryManager) {
        this.contextManager = contextManager;
        this.factoryManager = factoryManager;
    }

    @Override
    public ConnectionFactory resolve(ConnectionFactoryDefinition definition) throws JmsResolutionException {
        try {
            String name = definition.getName();
            ConnectionFactory factory = (ConnectionFactory)this.contextManager.lookup(ConnectionFactory.class, name);
            if (factory == null) {
                return null;
            }
            return this.factoryManager.register(name, factory, definition.getProperties());
        }
        catch (NamingException | FactoryRegistrationException e) {
            throw new JmsResolutionException((Throwable)e);
        }
    }

    @Override
    public Destination resolve(DestinationDefinition definition) throws JmsResolutionException {
        try {
            return (Destination)this.contextManager.lookup(Destination.class, definition.getName());
        }
        catch (NamingException e) {
            throw new JmsResolutionException(e);
        }
    }
}

