/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.container;

import java.net.URI;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.fabric3.binding.jms.runtime.container.ContainerStatistics;
import org.fabric3.binding.jms.runtime.container.UnitOfWork;
import org.fabric3.binding.jms.runtime.container.WorkException;

public class LocalTransactionUnitOfWork
implements UnitOfWork {
    private URI uri;
    private ContainerStatistics statistics;

    public LocalTransactionUnitOfWork(URI uri, ContainerStatistics statistics) {
        this.uri = uri;
        this.statistics = statistics;
    }

    @Override
    public void begin() throws WorkException {
    }

    @Override
    public void end(Session session, Message message) throws WorkException {
        try {
            session.commit();
        }
        catch (JMSException e) {
            throw new WorkException("Error handling message for " + this.uri, e);
        }
        this.statistics.incrementTransactions();
    }

    @Override
    public void rollback(Session session) throws WorkException {
        try {
            session.rollback();
        }
        catch (JMSException e) {
            throw new WorkException("Error handling message for " + this.uri, e);
        }
        this.statistics.incrementTransactionsRolledBack();
    }
}

