/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.container;

import java.net.URI;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import javax.jms.Topic;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.binding.jms.model.DestinationType;
import org.fabric3.binding.jms.runtime.common.JmsHelper;
import org.fabric3.binding.jms.runtime.container.ConnectionManager;
import org.fabric3.binding.jms.runtime.container.ContainerConfiguration;
import org.fabric3.binding.jms.runtime.container.ContainerStatistics;
import org.fabric3.binding.jms.runtime.container.MessageContainerMonitor;
import org.fabric3.binding.jms.runtime.container.UnitOfWork;
import org.fabric3.binding.jms.runtime.container.WorkException;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.fabric3.spi.container.wire.InvocationRuntimeException;
import org.fabric3.spi.threadpool.ExecutionContext;
import org.fabric3.spi.threadpool.ExecutionContextTunnel;

@Management
public class AdaptiveMessageContainer {
    private final ConnectionManager connectionManager;
    private UnitOfWork work;
    private ContainerStatistics statistics;
    private ExecutorService executorService;
    private MessageContainerMonitor monitor;
    private int receiveTimeout;
    private URI containerUri;
    private DestinationType destinationType;
    private Destination destination;
    private int cacheLevel;
    private SessionType sessionType;
    private int minReceivers;
    private int maxReceivers;
    private int idleLimit;
    private int maxMessagesToProcess;
    private long recoveryInterval;
    private String subscriptionId;
    private boolean localDelivery;
    private String messageSelector;
    private MessageListener messageListener;
    private ExceptionListener exceptionListener;
    private boolean initialized;
    private boolean running;
    private int activeReceiverCount;
    private final Object syncMonitor = new Object();
    private final Object recoverySyncMonitor = new Object();
    private Object recoveryMarker = new Object();
    private Set<MessageReceiver> receivers = new HashSet<MessageReceiver>();
    private List<Runnable> pausedWork = new LinkedList<Runnable>();
    private boolean javaEEXAEnabled;

    public AdaptiveMessageContainer(ContainerConfiguration configuration, int receiveTimeout, ConnectionManager connectionManager, UnitOfWork work, ContainerStatistics statistics, ExecutorService executorService, boolean javaEEXAEnabled, MessageContainerMonitor monitor) {
        this.containerUri = configuration.getUri();
        this.destinationType = configuration.getDestinationType();
        this.destination = configuration.getDestination();
        this.cacheLevel = configuration.getCacheLevel();
        this.sessionType = configuration.getSessionType();
        this.messageListener = configuration.getMessageListener();
        this.exceptionListener = configuration.getExceptionListener();
        this.messageSelector = configuration.getMessageSelector();
        this.subscriptionId = configuration.getSubscriptionId();
        this.setReceiveTimeout(receiveTimeout);
        this.setMaxMessagesToProcess(configuration.getMaxMessagesToProcess());
        this.setMaxReceivers(configuration.getMaxReceivers());
        this.setMinReceivers(configuration.getMinReceivers());
        this.setRecoveryInterval(configuration.getRecoveryInterval());
        this.setIdleLimit(configuration.getIdleLimit());
        this.setRecoveryInterval(configuration.getRecoveryInterval());
        this.connectionManager = connectionManager;
        this.work = work;
        this.statistics = statistics;
        this.executorService = executorService;
        this.javaEEXAEnabled = javaEEXAEnabled;
        this.monitor = monitor;
    }

    @ManagementOperation(description="The timeout value for receiving messages from a destination")
    public void setReceiveTimeout(int timeout) {
        if (timeout <= 0) {
            throw new IllegalArgumentException("Receive timeout must be greater than 0");
        }
        this.receiveTimeout = timeout;
    }

    @ManagementOperation(description="The timeout value for receiving messages from a destination")
    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    @ManagementOperation(description="The time to wait while making repeated recovery attempts")
    public void setRecoveryInterval(long interval) {
        this.recoveryInterval = interval;
    }

    @ManagementOperation(description="The time to wait while making repeated recovery attempts")
    public long getRecoveryInterval() {
        return this.recoveryInterval;
    }

    @ManagementOperation(description="The cache level")
    public String getLevel() {
        if (this.cacheLevel == 1) {
            return "Connection";
        }
        if (this.cacheLevel == 2) {
            return "Administered Objects";
        }
        return "None";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The minimum number of receivers to create for a destination")
    public void setMinReceivers(int min) {
        Object object = this.syncMonitor;
        synchronized (object) {
            this.minReceivers = min;
            if (this.maxReceivers < min) {
                this.maxReceivers = min;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The minimum number of receivers to create for a destination")
    public int getMinReceivers() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.minReceivers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The maximum number of receivers to create for a destination")
    public void setMaxReceivers(int max) {
        Object object = this.syncMonitor;
        synchronized (object) {
            this.maxReceivers = max > this.minReceivers ? max : this.minReceivers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The maximum number of receivers to create for a destination")
    public int getMaxReceivers() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.maxReceivers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The number of scheduled receivers")
    public int getReceiverCount() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.receivers.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The number of receivers actively processing messages")
    public int getActiveReceiverCount() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.activeReceiverCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The number of paused receivers")
    public int getPausedReceiversCount() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.pausedWork.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The times a receiver can be marked idle during execution before it is removed from the work scheduler")
    public void setIdleLimit(int limit) {
        Object object = this.syncMonitor;
        synchronized (object) {
            this.idleLimit = limit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The times a receiver can be marked idle during execution before it is removed from the work scheduler")
    public int getIdleLimit() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.idleLimit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The maximum number of messages to process by a receivers")
    public void setMaxMessagesToProcess(int max) {
        Object object = this.syncMonitor;
        synchronized (object) {
            this.maxMessagesToProcess = max;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="The maximum number of messages to process by a receivers")
    public int getMaxMessagesToProcess() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.maxMessagesToProcess;
        }
    }

    @ManagementOperation(description="If durable topic subscriptions are used")
    public boolean isDurable() {
        return this.connectionManager.isDurable();
    }

    @ManagementOperation(description="The durable topic subscription name")
    public String getSubscriptionId() {
        return this.subscriptionId;
    }

    @ManagementOperation(description="The session type")
    public String getSessionType() {
        return this.sessionType.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="True if the container is initialized")
    public boolean isInitialized() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.initialized;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="True if the container is running")
    public boolean isRunning() {
        Object object = this.syncMonitor;
        synchronized (object) {
            return this.running;
        }
    }

    @ManagementOperation(description="The current number of idle receivers")
    public int getIdleCount() {
        int count = 0;
        for (MessageReceiver receiver : this.receivers) {
            if (!receiver.isIdle()) continue;
            ++count;
        }
        return count;
    }

    @ManagementOperation(description="The time this container has been running")
    public long getTotalTime() {
        return this.statistics.getTotalTime();
    }

    @ManagementOperation(description="The number of messages received")
    public long getMessagesReceived() {
        return this.statistics.getMessagesReceived();
    }

    @ManagementOperation(description="The maximum number of active receivers reached")
    public int getMaxReceiversReached() {
        return this.statistics.getMaxReceivers();
    }

    @ManagementOperation(description="The total number of committed transactions")
    public int getTransactions() {
        return this.statistics.getTransactions();
    }

    @ManagementOperation(description="The total number of rolled back transactions")
    public int getTransactionsRolledBack() {
        return this.statistics.getTransactionsRolledBack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="Starts the containing processing messages")
    public void start() throws JMSException {
        this.connectionManager.start();
        Object object = this.syncMonitor;
        synchronized (object) {
            this.running = true;
            this.syncMonitor.notifyAll();
            this.resumePausedWork();
        }
        if (this.cacheLevel >= 1) {
            this.connectionManager.startSharedConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManagementOperation(description="Stops the containing processing messages")
    public void stop() {
        Object object = this.syncMonitor;
        synchronized (object) {
            this.running = false;
            this.syncMonitor.notifyAll();
        }
        if (this.cacheLevel >= 1) {
            this.connectionManager.stopSharedConnection();
        }
    }

    public URI getContainerUri() {
        return this.containerUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws JMSException {
        try {
            Object object = this.syncMonitor;
            synchronized (object) {
                this.initialized = true;
                this.syncMonitor.notifyAll();
            }
            this.start();
            object = this.syncMonitor;
            synchronized (object) {
                for (int i = 0; i < this.minReceivers; ++i) {
                    this.addReceiver();
                }
            }
        }
        catch (JMSException e) {
            this.connectionManager.close();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.syncMonitor;
        synchronized (object) {
            boolean wasRunning = this.running;
            this.running = false;
            this.initialized = false;
            this.syncMonitor.notifyAll();
            if (wasRunning && this.cacheLevel >= 1) {
                this.connectionManager.stopSharedConnection();
            }
            try {
                while (this.activeReceiverCount > 0) {
                    this.syncMonitor.wait();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
            finally {
                if (this.cacheLevel >= 1) {
                    this.connectionManager.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resizePool() {
        if (this.isRunning()) {
            this.resumePausedWork();
            Object object = this.syncMonitor;
            synchronized (object) {
                if (this.receivers.size() < this.maxReceivers && this.getIdleCount() == 0) {
                    this.addReceiver();
                }
            }
        }
    }

    private void addReceiver() {
        MessageReceiver receiver = new MessageReceiver();
        if (this.rescheduleWork(receiver)) {
            this.receivers.add(receiver);
            if (this.statistics.getMaxReceivers() < this.receivers.size()) {
                this.statistics.incrementMaxReceivers();
            }
            this.monitor.increaseReceivers(this.receivers.size());
        }
    }

    private boolean shouldRescheduleReceiver(int count) {
        boolean extra = count >= this.idleLimit && this.getIdleCount() > 1;
        return this.receivers.size() <= (extra ? this.minReceivers : this.maxReceivers);
    }

    private void refreshConnection() {
        while (this.isRunning()) {
            if (this.connectionManager.refreshConnection()) {
                return;
            }
            this.sleep();
        }
    }

    private void handleReceiveException(Throwable e) {
        if (e instanceof JMSException && this.exceptionListener != null) {
            this.exceptionListener.onException((JMSException)e);
        }
        this.monitor.listenerError(this.containerUri.toString(), e);
    }

    private boolean rescheduleWork(Runnable runnable) {
        if (this.isRunning()) {
            try {
                this.executorService.execute(runnable);
            }
            catch (RuntimeException e) {
                this.monitor.reject(e);
                this.pausedWork.add(runnable);
            }
            return true;
        }
        if (this.initialized) {
            this.pausedWork.add(runnable);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resumePausedWork() {
        Object object = this.syncMonitor;
        synchronized (object) {
            if (!this.pausedWork.isEmpty()) {
                Iterator<Runnable> it = this.pausedWork.iterator();
                while (it.hasNext()) {
                    Runnable runnable = it.next();
                    try {
                        this.executorService.execute(runnable);
                        it.remove();
                    }
                    catch (RuntimeException e) {
                        this.monitor.reject(e);
                    }
                }
            }
        }
    }

    private Session createSession(Connection connection) throws JMSException {
        boolean transacted;
        if (this.javaEEXAEnabled && SessionType.GLOBAL_TRANSACTED == this.sessionType) {
            return connection.createSession(false, 0);
        }
        boolean bl = transacted = SessionType.LOCAL_TRANSACTED == this.sessionType || SessionType.GLOBAL_TRANSACTED == this.sessionType;
        if (transacted) {
            return connection.createSession(transacted, 1);
        }
        if (SessionType.AUTO_ACKNOWLEDGE == this.sessionType) {
            return connection.createSession(false, 1);
        }
        return connection.createSession(false, 2);
    }

    private MessageConsumer createConsumer(Session session) throws JMSException {
        if (DestinationType.TOPIC == this.destinationType) {
            if (this.isDurable()) {
                return session.createDurableSubscriber((Topic)this.destination, this.subscriptionId, this.messageSelector, this.localDelivery);
            }
            return session.createConsumer(this.destination, this.messageSelector, this.localDelivery);
        }
        return session.createConsumer(this.destination, this.messageSelector);
    }

    private void sleep() {
        if (this.recoveryInterval > 0L) {
            try {
                Thread.sleep(this.recoveryInterval);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private class MessageReceiver
    implements Runnable {
        private Connection connection;
        private Session session;
        private MessageConsumer consumer;
        private Object previousRecoveryMarker;
        private boolean previousSucceeded;
        private int idleWorkCount = 0;
        private volatile boolean idle = true;

        private MessageReceiver() {
        }

        public boolean isIdle() {
            return this.idle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = AdaptiveMessageContainer.this.syncMonitor;
            synchronized (object) {
                AdaptiveMessageContainer.this.activeReceiverCount++;
                AdaptiveMessageContainer.this.syncMonitor.notifyAll();
            }
            boolean messageReceived = false;
            try {
                if (AdaptiveMessageContainer.this.maxMessagesToProcess < 0) {
                    AdaptiveMessageContainer.this.monitor.scheduledReceiver(AdaptiveMessageContainer.this.destination.toString());
                    messageReceived = this.receiveLoop();
                } else {
                    for (int messageCount = 0; AdaptiveMessageContainer.this.isRunning() && messageCount < AdaptiveMessageContainer.this.maxMessagesToProcess; ++messageCount) {
                        messageReceived = this.receive() || messageReceived;
                    }
                }
            }
            catch (Throwable e) {
                this.closeSession();
                if (!this.previousSucceeded) {
                    AdaptiveMessageContainer.this.sleep();
                }
                this.previousSucceeded = false;
                AdaptiveMessageContainer.this.handleReceiveException(e);
                Object object2 = AdaptiveMessageContainer.this.recoverySyncMonitor;
                synchronized (object2) {
                    if (this.previousRecoveryMarker == AdaptiveMessageContainer.this.recoveryMarker) {
                        AdaptiveMessageContainer.this.refreshConnection();
                        AdaptiveMessageContainer.this.recoveryMarker = new Object();
                    }
                }
            }
            Object object3 = AdaptiveMessageContainer.this.syncMonitor;
            synchronized (object3) {
                AdaptiveMessageContainer.this.activeReceiverCount--;
                AdaptiveMessageContainer.this.syncMonitor.notifyAll();
            }
            this.idleWorkCount = !messageReceived ? ++this.idleWorkCount : 0;
            object3 = AdaptiveMessageContainer.this.syncMonitor;
            synchronized (object3) {
                if (!AdaptiveMessageContainer.this.shouldRescheduleReceiver(this.idleWorkCount) || !AdaptiveMessageContainer.this.rescheduleWork(this)) {
                    AdaptiveMessageContainer.this.receivers.remove(this);
                    AdaptiveMessageContainer.this.monitor.decreaseReceivers(AdaptiveMessageContainer.this.receivers.size());
                    AdaptiveMessageContainer.this.syncMonitor.notifyAll();
                    this.closeSession();
                } else if (AdaptiveMessageContainer.this.isRunning()) {
                    int nonPausedReceivers = AdaptiveMessageContainer.this.getReceiverCount() - AdaptiveMessageContainer.this.getPausedReceiversCount();
                    if (nonPausedReceivers < 1) {
                        AdaptiveMessageContainer.this.monitor.pauseError(AdaptiveMessageContainer.this.containerUri.toString());
                    } else if (nonPausedReceivers < AdaptiveMessageContainer.this.getMinReceivers()) {
                        AdaptiveMessageContainer.this.monitor.minimumError(AdaptiveMessageContainer.this.containerUri.toString());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private boolean receiveLoop() throws JMSException, WorkException {
            boolean received = false;
            boolean active = true;
            while (true) {
                if (!active) {
                    this.closeResources(true);
                    return received;
                }
                ExecutionContext context = ExecutionContextTunnel.getThreadExecutionContext();
                Object object = AdaptiveMessageContainer.this.syncMonitor;
                synchronized (object) {
                    try {
                        if (context != null) {
                            context.start();
                        }
                        boolean interrupted = false;
                        boolean waiting = false;
                        while ((active = AdaptiveMessageContainer.this.isInitialized()) && !AdaptiveMessageContainer.this.isRunning()) {
                            if (interrupted) {
                                throw new IllegalStateException("Interrupted while waiting for restart for " + AdaptiveMessageContainer.this.containerUri);
                            }
                            if (!AdaptiveMessageContainer.this.isRunning()) {
                                boolean bl = false;
                                return bl;
                            }
                            if (!waiting && AdaptiveMessageContainer.this.isRunning()) {
                                AdaptiveMessageContainer.this.activeReceiverCount--;
                            }
                            waiting = true;
                            try {
                                AdaptiveMessageContainer.this.syncMonitor.wait();
                            }
                            catch (InterruptedException ex) {
                                Thread.currentThread().interrupt();
                                interrupted = true;
                            }
                        }
                        if (waiting) {
                            AdaptiveMessageContainer.this.activeReceiverCount++;
                        }
                        if (context != null) {
                            context.stop();
                        }
                    }
                    finally {
                        if (context != null) {
                            context.clear();
                        }
                    }
                    if (!active) continue;
                }
                received = this.receive() || received;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean receive() throws JMSException, WorkException {
            try {
                this.setRecoveryMarker();
                boolean received = this.doReceive();
                this.previousSucceeded = true;
                boolean bl = received;
                return bl;
            }
            finally {
                this.closeResources(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doReceive() throws JMSException, WorkException {
            Message message;
            block13: {
                Object object = AdaptiveMessageContainer.this.syncMonitor;
                synchronized (object) {
                    if (!AdaptiveMessageContainer.this.isRunning()) {
                        return false;
                    }
                    AdaptiveMessageContainer.this.work.begin();
                    this.connection = AdaptiveMessageContainer.this.connectionManager.getConnection();
                }
                if (this.session == null) {
                    this.session = AdaptiveMessageContainer.this.createSession(this.connection);
                }
                if (this.consumer == null) {
                    this.consumer = AdaptiveMessageContainer.this.createConsumer(this.session);
                }
                message = null;
                try {
                    message = this.consumer.receive((long)AdaptiveMessageContainer.this.receiveTimeout);
                }
                catch (JMSException e) {
                    if (e.getCause() instanceof InterruptedException) break block13;
                    throw e;
                }
            }
            if (message != null) {
                if (!AdaptiveMessageContainer.this.isRunning()) {
                    AdaptiveMessageContainer.this.work.rollback(this.session);
                    this.idle = true;
                    return false;
                }
                this.idle = false;
                AdaptiveMessageContainer.this.resizePool();
                try {
                    AdaptiveMessageContainer.this.messageListener.onMessage(message);
                    AdaptiveMessageContainer.this.statistics.incrementMessagesReceived();
                    AdaptiveMessageContainer.this.work.end(this.session, message);
                    return true;
                }
                catch (InvocationRuntimeException e) {
                    AdaptiveMessageContainer.this.monitor.receiveError(AdaptiveMessageContainer.this.containerUri, e.getCause());
                    AdaptiveMessageContainer.this.work.rollback(this.session);
                }
                catch (Error | RuntimeException e) {
                    AdaptiveMessageContainer.this.monitor.receiveError(AdaptiveMessageContainer.this.containerUri, e);
                    AdaptiveMessageContainer.this.work.rollback(this.session);
                }
                return false;
            }
            this.idle = true;
            AdaptiveMessageContainer.this.work.end(this.session, message);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeSession() {
            ConnectionManager connectionManager = AdaptiveMessageContainer.this.connectionManager;
            synchronized (connectionManager) {
                if (AdaptiveMessageContainer.this.isDurable() && this.session != null) {
                    try {
                        this.session.unsubscribe(AdaptiveMessageContainer.this.subscriptionId);
                    }
                    catch (JMSException e) {
                        AdaptiveMessageContainer.this.monitor.listenerError(AdaptiveMessageContainer.this.containerUri.toString(), e);
                    }
                }
                JmsHelper.closeQuietly(this.session);
            }
            this.session = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void closeResources(boolean force) {
            ConnectionManager connectionManager = AdaptiveMessageContainer.this.connectionManager;
            synchronized (connectionManager) {
                if (AdaptiveMessageContainer.this.cacheLevel < 2 || force) {
                    JmsHelper.closeQuietly(this.consumer);
                    JmsHelper.closeQuietly(this.session);
                    this.consumer = null;
                    this.session = null;
                }
                if (AdaptiveMessageContainer.this.cacheLevel == 0 || force) {
                    JmsHelper.closeQuietly(this.connection);
                    this.connection = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setRecoveryMarker() {
            Object object = AdaptiveMessageContainer.this.recoverySyncMonitor;
            synchronized (object) {
                this.previousRecoveryMarker = AdaptiveMessageContainer.this.recoveryMarker;
            }
        }
    }
}

