/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import org.fabric3.api.binding.jms.resource.ConnectionFactoryConfiguration;
import org.fabric3.binding.jms.spi.runtime.connection.ConnectionFactoryCreationException;
import org.fabric3.binding.jms.spi.runtime.connection.ConnectionFactoryCreatorRegistry;
import org.fabric3.binding.jms.spi.runtime.provider.ConnectionFactoryCreator;
import org.oasisopen.sca.annotation.Reference;

public class ConnectionFactoryCreatorRegistryImpl
implements ConnectionFactoryCreatorRegistry {
    private Map<String, ConnectionFactoryCreator> creators = Collections.emptyMap();
    private Map<ConnectionFactory, ConnectionFactoryCreator> factories = new HashMap<ConnectionFactory, ConnectionFactoryCreator>();

    @Reference(required=false)
    public void setCreators(Map<String, ConnectionFactoryCreator> creators) {
        this.creators = creators;
    }

    @Override
    public ConnectionFactory create(ConnectionFactoryConfiguration configuration) throws ConnectionFactoryCreationException {
        ConnectionFactoryCreator creator;
        if (this.creators.isEmpty()) {
            throw new ConnectionFactoryCreationException("JMS Provider not installed");
        }
        String provider = configuration.getProvider();
        ConnectionFactoryCreator connectionFactoryCreator = creator = provider == null ? this.creators.values().iterator().next() : this.creators.get(provider);
        if (creator == null) {
            throw new ConnectionFactoryCreationException("Provider not found: " + provider);
        }
        ConnectionFactory factory = creator.create(configuration);
        this.factories.put(factory, creator);
        return factory;
    }

    @Override
    public void release(ConnectionFactory factory) {
        ConnectionFactoryCreator creator = this.factories.remove(factory);
        if (creator == null) {
            return;
        }
        creator.release(factory);
    }
}

