/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jms.ConnectionFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.api.binding.jms.resource.ConnectionFactoryConfiguration;
import org.fabric3.api.binding.jms.resource.ConnectionFactoryType;
import org.fabric3.api.host.failure.ValidationFailure;
import org.fabric3.binding.jms.spi.introspection.ConnectionFactoryConfigurationParser;
import org.fabric3.binding.jms.spi.runtime.connection.ConnectionFactoryCreationException;
import org.fabric3.binding.jms.spi.runtime.connection.ConnectionFactoryCreatorRegistry;
import org.fabric3.binding.jms.spi.runtime.manager.ConnectionFactoryManager;
import org.fabric3.binding.jms.spi.runtime.manager.FactoryRegistrationException;
import org.fabric3.binding.jms.spi.runtime.provider.DefaultConnectionFactoryBuilder;
import org.fabric3.binding.jms.spi.runtime.provider.InvalidConfigurationException;
import org.fabric3.spi.introspection.DefaultIntrospectionContext;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.oasisopen.sca.annotation.Destroy;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Property;
import org.oasisopen.sca.annotation.Reference;

@EagerInit
public class ConfigurationBuilder {
    private ConnectionFactoryCreatorRegistry creatorRegistry;
    private ConnectionFactoryManager manager;
    private String defaultProvider;
    private Map<String, ConnectionFactoryConfigurationParser> parsers = Collections.emptyMap();
    private Map<String, DefaultConnectionFactoryBuilder> defaultBuilders = Collections.emptyMap();
    private List<ConnectionFactoryConfiguration> factoryConfigurations = new ArrayList<ConnectionFactoryConfiguration>();
    private List<ConnectionFactory> factories = new ArrayList<ConnectionFactory>();

    public ConfigurationBuilder(@Reference ConnectionFactoryCreatorRegistry creatorRegistry, @Reference ConnectionFactoryManager manager) {
        this.creatorRegistry = creatorRegistry;
        this.manager = manager;
    }

    @Reference(required=false)
    public void setParsers(Map<String, ConnectionFactoryConfigurationParser> parsers) {
        this.parsers = parsers;
    }

    @Reference(required=false)
    public void setDefaultBuilders(Map<String, DefaultConnectionFactoryBuilder> defaultBuilders) {
        this.defaultBuilders = defaultBuilders;
    }

    @Property(required=false)
    public void setDefaultProvider(String defaultProvider) {
        this.defaultProvider = defaultProvider;
    }

    @Property(required=false)
    public void setConnectionFactories(XMLStreamReader reader) throws XMLStreamException, InvalidConfigurationException {
        this.factoryConfigurations.clear();
        this.parseConfigurations(this.factoryConfigurations, reader);
    }

    @Init
    public void init() throws FactoryRegistrationException, ConnectionFactoryCreationException {
        for (ConnectionFactoryConfiguration configuration : this.factoryConfigurations) {
            ConnectionFactory factory = this.creatorRegistry.create(configuration);
            this.manager.register(configuration.getName(), factory, this.getProperties(configuration));
            this.factories.add(factory);
        }
        if (!this.defaultBuilders.isEmpty()) {
            DefaultConnectionFactoryBuilder builder;
            if (this.defaultProvider != null) {
                builder = this.defaultBuilders.get(this.defaultProvider);
                if (builder == null) {
                    throw new ConnectionFactoryCreationException("Unable to create default connection factories. Provider not found: " + this.defaultProvider);
                }
            } else {
                builder = this.defaultBuilders.values().iterator().next();
            }
            ConnectionFactoryConfiguration localConfig = builder.createDefaultFactory("default", ConnectionFactoryType.LOCAL);
            ConnectionFactoryConfiguration xaConfig = builder.createDefaultFactory("xaDefault", ConnectionFactoryType.XA);
            if (this.manager.get("default") == null) {
                ConnectionFactory factory = this.creatorRegistry.create(localConfig);
                this.manager.register("default", factory, this.getProperties(localConfig));
            }
            if (this.manager.get("xaDefault") == null) {
                ConnectionFactory xaFactory = this.creatorRegistry.create(xaConfig);
                this.manager.register("xaDefault", xaFactory, this.getProperties(localConfig));
            }
        }
    }

    @Destroy
    public void destroy() throws FactoryRegistrationException {
        for (ConnectionFactoryConfiguration configuration : this.factoryConfigurations) {
            this.manager.unregister(configuration.getName());
        }
        Iterator<ConnectionFactory> iterator = this.factories.iterator();
        while (iterator.hasNext()) {
            ConnectionFactory factory = iterator.next();
            this.creatorRegistry.release(factory);
            iterator.remove();
        }
    }

    private void parseConfigurations(List<ConnectionFactoryConfiguration> configurations, XMLStreamReader reader) throws XMLStreamException, InvalidConfigurationException {
        while (true) {
            switch (reader.next()) {
                case 1: {
                    ConnectionFactoryConfigurationParser parser;
                    String name = reader.getName().getLocalPart();
                    if (!name.equals("connection.factory")) break;
                    if (this.parsers.isEmpty()) {
                        throw new InvalidConfigurationException("JMS provider not installed");
                    }
                    String provider = reader.getAttributeValue(null, "provider");
                    if (provider == null) {
                        parser = this.parsers.values().iterator().next();
                    } else {
                        parser = this.parsers.get(provider);
                        if (parser == null) {
                            throw new InvalidConfigurationException("JMS provider not installed: " + provider);
                        }
                    }
                    DefaultIntrospectionContext context = new DefaultIntrospectionContext();
                    ConnectionFactoryConfiguration configuration = parser.parse(reader, (IntrospectionContext)context);
                    this.checkErrors(context);
                    configurations.add(configuration);
                    break;
                }
                case 8: {
                    return;
                }
            }
        }
    }

    private void checkErrors(DefaultIntrospectionContext context) throws InvalidConfigurationException {
        if (context.hasErrors()) {
            StringBuilder builder = new StringBuilder();
            builder.append("The following errors were found:\n");
            for (ValidationFailure error : context.getErrors()) {
                builder.append(error.getMessage()).append("\n");
            }
            throw new InvalidConfigurationException(builder.toString());
        }
    }

    private Map<String, String> getProperties(ConnectionFactoryConfiguration configuration) {
        Properties properties = configuration.getFactoryProperties();
        HashMap<String, String> factoryProperties = new HashMap<String, String>();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            factoryProperties.put(entry.getKey().toString(), entry.getValue().toString());
        }
        return factoryProperties;
    }
}

