/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime.channel;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.TextMessage;
import org.fabric3.binding.jms.runtime.common.ListenerMonitor;
import org.fabric3.spi.container.channel.EventStreamHandler;

public class EventStreamListener
implements MessageListener {
    private ClassLoader cl;
    private ListenerMonitor monitor;
    private EventStreamHandler handler;

    public EventStreamListener(ClassLoader cl, EventStreamHandler handler, ListenerMonitor monitor) {
        this.cl = cl;
        this.handler = handler;
        this.monitor = monitor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message request) {
        ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.cl);
            if (request instanceof ObjectMessage) {
                ObjectMessage message = (ObjectMessage)request;
                this.handler.handle((Object)message.getObject(), true);
            } else if (request instanceof TextMessage) {
                TextMessage message = (TextMessage)request;
                this.handler.handle((Object)message.getText(), true);
            } else {
                String type = request.getClass().getName();
                this.monitor.invalidMessageType(type);
            }
        }
        catch (JMSException e) {
            this.monitor.redeliveryError(e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldCl);
        }
    }
}

