/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.binding.jms.model.CacheLevel;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.CorrelationScheme;
import org.fabric3.api.binding.jms.model.DestinationDefinition;
import org.fabric3.api.binding.jms.model.DestinationType;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.binding.jms.runtime.common.ListenerMonitor;
import org.fabric3.binding.jms.runtime.container.AdaptiveMessageContainer;
import org.fabric3.binding.jms.runtime.container.ContainerConfiguration;
import org.fabric3.binding.jms.runtime.container.MessageContainerFactory;
import org.fabric3.binding.jms.runtime.container.MessageContainerManager;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.runtime.wire.InvocationChainHolder;
import org.fabric3.binding.jms.runtime.wire.ServiceListener;
import org.fabric3.binding.jms.runtime.wire.WireHolder;
import org.fabric3.binding.jms.spi.provision.JmsWireSourceDefinition;
import org.fabric3.binding.jms.spi.provision.OperationPayloadTypes;
import org.fabric3.binding.jms.spi.provision.SessionType;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.binding.handler.BindingHandler;
import org.fabric3.spi.container.binding.handler.BindingHandlerRegistry;
import org.fabric3.spi.container.builder.component.SourceWireAttacher;
import org.fabric3.spi.container.objectfactory.ObjectFactory;
import org.fabric3.spi.container.wire.InvocationChain;
import org.fabric3.spi.container.wire.Wire;
import org.fabric3.spi.model.physical.PhysicalBindingHandlerDefinition;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalWireTargetDefinition;
import org.fabric3.spi.xml.XMLFactory;
import org.oasisopen.sca.annotation.Reference;

public class JmsSourceWireAttacher
implements SourceWireAttacher<JmsWireSourceDefinition> {
    private AdministeredObjectResolver resolver;
    private ClassLoaderRegistry classLoaderRegistry;
    private MessageContainerFactory containerFactory;
    private MessageContainerManager containerManager;
    private ListenerMonitor monitor;
    private XMLFactory xmlFactory;
    private BindingHandlerRegistry handlerRegistry;

    public JmsSourceWireAttacher(@Reference AdministeredObjectResolver resolver, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference MessageContainerFactory containerFactory, @Reference MessageContainerManager containerManager, @Reference XMLFactory xmlFactory, @Reference BindingHandlerRegistry handlerRegistry, @Monitor ListenerMonitor monitor) {
        this.resolver = resolver;
        this.classLoaderRegistry = classLoaderRegistry;
        this.containerFactory = containerFactory;
        this.containerManager = containerManager;
        this.xmlFactory = xmlFactory;
        this.monitor = monitor;
        this.handlerRegistry = handlerRegistry;
    }

    public void attach(JmsWireSourceDefinition source, PhysicalWireTargetDefinition target, Wire wire) throws ContainerException {
        URI serviceUri = target.getUri();
        ClassLoader loader = this.classLoaderRegistry.getClassLoader(source.getClassLoaderId());
        SessionType trxType = source.getSessionType();
        WireHolder wireHolder = this.createWireHolder(wire, source, trxType);
        ResolvedObjects objects = this.resolveAdministeredObjects(source);
        ContainerConfiguration configuration = new ContainerConfiguration();
        try {
            ConnectionFactory requestFactory = objects.getRequestFactory();
            Destination requestDestination = objects.getRequestDestination();
            ConnectionFactory responseFactory = objects.getResponseFactory();
            Destination responseDestination = objects.getResponseDestination();
            List<BindingHandler<Message>> handlers = this.createHandlers(source);
            ServiceListener listener = new ServiceListener(wireHolder, responseDestination, responseFactory, trxType, loader, this.xmlFactory, handlers, this.monitor);
            configuration.setDestination(requestDestination);
            configuration.setFactory(requestFactory);
            configuration.setMessageListener(listener);
            configuration.setUri(serviceUri);
            configuration.setSessionType(trxType);
            this.populateConfiguration(configuration, source.getMetadata());
            if (this.containerManager.isRegistered(serviceUri)) {
                this.containerManager.unregister(serviceUri);
            }
            AdaptiveMessageContainer container = this.containerFactory.create(configuration);
            this.containerManager.register(container);
        }
        catch (JMSException e) {
            throw new ContainerException((Throwable)e);
        }
    }

    private void populateConfiguration(ContainerConfiguration configuration, JmsBindingMetadata metadata) {
        CacheLevel cacheLevel = metadata.getCacheLevel();
        if (CacheLevel.CONNECTION == cacheLevel) {
            configuration.setCacheLevel(1);
        } else if (CacheLevel.ADMINISTERED_OBJECTS == cacheLevel) {
            configuration.setCacheLevel(2);
        } else {
            configuration.setCacheLevel(0);
        }
        configuration.setIdleLimit(metadata.getIdleLimit());
        configuration.setMaxMessagesToProcess(metadata.getMaxMessagesToProcess());
        configuration.setMaxReceivers(metadata.getMaxReceivers());
        configuration.setMinReceivers(metadata.getMinReceivers());
        configuration.setReceiveTimeout(metadata.getReceiveTimeout());
        if (metadata.getUriMessageSelection() != null) {
            configuration.setMessageSelector(metadata.getUriMessageSelection().getSelector());
        } else if (metadata.getMessageSelection() != null) {
            configuration.setMessageSelector(metadata.getMessageSelection().getSelector());
        }
    }

    public void detach(JmsWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
        try {
            this.containerManager.unregister(target.getUri());
            this.resolver.release(source.getMetadata().getConnectionFactory());
        }
        catch (JMSException e) {
            throw new ContainerException((Throwable)e);
        }
    }

    public void attachObjectFactory(JmsWireSourceDefinition source, ObjectFactory<?> objectFactory, PhysicalWireTargetDefinition definition) throws ContainerException {
        throw new UnsupportedOperationException();
    }

    public void detachObjectFactory(JmsWireSourceDefinition source, PhysicalWireTargetDefinition target) throws ContainerException {
        throw new AssertionError();
    }

    private ResolvedObjects resolveAdministeredObjects(JmsWireSourceDefinition source) throws ContainerException {
        JmsBindingMetadata metadata = source.getMetadata();
        ConnectionFactoryDefinition requestDefinition = metadata.getConnectionFactory();
        ConnectionFactory requestConnectionFactory = this.resolver.resolve(requestDefinition);
        DestinationDefinition requestDestinationDefinition = metadata.getDestination();
        Destination requestDestination = this.resolver.resolve(requestDestinationDefinition, requestConnectionFactory);
        this.validateDestination(requestDestination, requestDestinationDefinition);
        ConnectionFactory responseConnectionFactory = null;
        Destination responseDestination = null;
        if (metadata.isResponse()) {
            ConnectionFactoryDefinition responseDefinition = metadata.getResponseConnectionFactory();
            responseConnectionFactory = this.resolver.resolve(responseDefinition);
            DestinationDefinition responseDestinationDefinition = metadata.getResponseDestination();
            if (responseDestinationDefinition != null) {
                responseDestination = this.resolver.resolve(responseDestinationDefinition, responseConnectionFactory);
                this.validateDestination(responseDestination, responseDestinationDefinition);
            }
        }
        return new ResolvedObjects(requestConnectionFactory, requestDestination, responseConnectionFactory, responseDestination);
    }

    private void validateDestination(Destination requestDestination, DestinationDefinition requestDestinationDefinition) throws ContainerException {
        DestinationType requestDestinationType = requestDestinationDefinition.geType();
        if (DestinationType.QUEUE == requestDestinationType && !(requestDestination instanceof Queue)) {
            throw new ContainerException("Destination is not a queue: " + requestDestinationDefinition.getName());
        }
        if (DestinationType.TOPIC == requestDestinationType && !(requestDestination instanceof Topic)) {
            throw new ContainerException("Destination is not a topic: " + requestDestinationDefinition.getName());
        }
    }

    private WireHolder createWireHolder(Wire wire, JmsWireSourceDefinition source, SessionType sessionType) throws ContainerException {
        JmsBindingMetadata metadata = source.getMetadata();
        List<OperationPayloadTypes> types = source.getPayloadTypes();
        CorrelationScheme correlationScheme = metadata.getCorrelationScheme();
        ArrayList<InvocationChainHolder> chainHolders = new ArrayList<InvocationChainHolder>();
        for (InvocationChain chain : wire.getInvocationChains()) {
            PhysicalOperationDefinition definition = chain.getPhysicalOperation();
            OperationPayloadTypes payloadType = this.resolveOperation(definition.getName(), types);
            if (payloadType == null) {
                throw new ContainerException("Payload type not found for operation: " + definition.getName());
            }
            chainHolders.add(new InvocationChainHolder(chain, payloadType));
        }
        return new WireHolder(chainHolders, correlationScheme);
    }

    private OperationPayloadTypes resolveOperation(String operationName, List<OperationPayloadTypes> payloadTypes) {
        for (OperationPayloadTypes type : payloadTypes) {
            if (!type.getName().equals(operationName)) continue;
            return type;
        }
        throw new AssertionError((Object)("Error resolving operation: " + operationName));
    }

    private List<BindingHandler<Message>> createHandlers(JmsWireSourceDefinition source) {
        if (source.getHandlers().isEmpty()) {
            return null;
        }
        ArrayList<BindingHandler<Message>> handlers = new ArrayList<BindingHandler<Message>>();
        for (PhysicalBindingHandlerDefinition handlerDefinition : source.getHandlers()) {
            BindingHandler handler = this.handlerRegistry.createHandler(Message.class, handlerDefinition);
            handlers.add((BindingHandler<Message>)handler);
        }
        return handlers;
    }

    private class ResolvedObjects {
        private ConnectionFactory requestFactory;
        private ConnectionFactory responseFactory;
        private Destination requestDestination;
        private Destination responseDestination;

        private ResolvedObjects(ConnectionFactory requestFactory, Destination requestDestination, ConnectionFactory responseFactory, Destination responseDestination) {
            this.requestFactory = requestFactory;
            this.requestDestination = requestDestination;
            this.responseFactory = responseFactory;
            this.responseDestination = responseDestination;
        }

        public ConnectionFactory getRequestFactory() {
            return this.requestFactory;
        }

        public ConnectionFactory getResponseFactory() {
            return this.responseFactory;
        }

        public Destination getRequestDestination() {
            return this.requestDestination;
        }

        public Destination getResponseDestination() {
            return this.responseDestination;
        }
    }
}

