/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.DeliveryMode;
import org.fabric3.api.binding.jms.model.DestinationDefinition;
import org.fabric3.api.binding.jms.model.HeadersDefinition;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.binding.jms.runtime.channel.JmsEventStreamHandler;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.spi.provision.JmsConnectionTargetDefinition;
import org.fabric3.binding.jms.spi.runtime.provider.JmsResolutionException;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.TargetConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.ChannelManager;
import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.container.channel.EventStreamHandler;
import org.fabric3.spi.model.physical.PhysicalConnectionSourceDefinition;
import org.oasisopen.sca.annotation.Reference;

public class JmsConnectionTargetAttacher
implements TargetConnectionAttacher<JmsConnectionTargetDefinition> {
    private AdministeredObjectResolver resolver;

    public JmsConnectionTargetAttacher(@Reference AdministeredObjectResolver resolver, @Reference ChannelManager channelManager) {
        this.resolver = resolver;
    }

    public void attach(PhysicalConnectionSourceDefinition source, JmsConnectionTargetDefinition target, ChannelConnection connection) throws ContainerException {
        Destination destination;
        ConnectionFactory connectionFactory;
        JmsBindingMetadata metadata = target.getMetadata();
        ConnectionFactoryDefinition connectionFactoryDefinition = metadata.getConnectionFactory();
        HeadersDefinition headers = metadata.getHeaders();
        boolean persistent = DeliveryMode.PERSISTENT == headers.getDeliveryMode() || headers.getDeliveryMode() == null;
        try {
            connectionFactory = this.resolver.resolve(connectionFactoryDefinition);
            DestinationDefinition destinationDefinition = metadata.getDestination();
            destination = this.resolver.resolve(destinationDefinition, connectionFactory);
        }
        catch (JmsResolutionException e) {
            throw new ContainerException((Throwable)((Object)e));
        }
        EventStream stream = connection.getEventStream();
        JmsEventStreamHandler handler = new JmsEventStreamHandler(destination, connectionFactory, persistent);
        stream.addHandler((EventStreamHandler)handler);
    }

    public void detach(PhysicalConnectionSourceDefinition source, JmsConnectionTargetDefinition target) throws ContainerException {
        this.resolver.release(target.getMetadata().getConnectionFactory());
    }
}

