/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.binding.jms.runtime;

import java.net.URI;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.api.binding.jms.model.CacheLevel;
import org.fabric3.api.binding.jms.model.ConnectionFactoryDefinition;
import org.fabric3.api.binding.jms.model.DestinationDefinition;
import org.fabric3.api.binding.jms.model.JmsBindingMetadata;
import org.fabric3.binding.jms.runtime.channel.EventStreamListener;
import org.fabric3.binding.jms.runtime.common.ListenerMonitor;
import org.fabric3.binding.jms.runtime.container.AdaptiveMessageContainer;
import org.fabric3.binding.jms.runtime.container.ContainerConfiguration;
import org.fabric3.binding.jms.runtime.container.MessageContainerFactory;
import org.fabric3.binding.jms.runtime.container.MessageContainerManager;
import org.fabric3.binding.jms.runtime.resolver.AdministeredObjectResolver;
import org.fabric3.binding.jms.spi.provision.JmsConnectionSourceDefinition;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.container.ContainerException;
import org.fabric3.spi.container.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.container.channel.ChannelConnection;
import org.fabric3.spi.container.channel.EventStream;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.oasisopen.sca.annotation.Reference;

public class JmsConnectionSourceAttacher
implements SourceConnectionAttacher<JmsConnectionSourceDefinition> {
    private AdministeredObjectResolver resolver;
    private ClassLoaderRegistry classLoaderRegistry;
    private MessageContainerFactory containerFactory;
    private MessageContainerManager containerManager;
    private ListenerMonitor monitor;

    public JmsConnectionSourceAttacher(@Reference AdministeredObjectResolver resolver, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference MessageContainerFactory containerFactory, @Reference MessageContainerManager containerManager, @Monitor ListenerMonitor monitor) {
        this.resolver = resolver;
        this.classLoaderRegistry = classLoaderRegistry;
        this.containerFactory = containerFactory;
        this.containerManager = containerManager;
        this.monitor = monitor;
    }

    public void attach(JmsConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target, ChannelConnection connection) throws ContainerException {
        URI serviceUri = source.getUri();
        ClassLoader sourceClassLoader = this.classLoaderRegistry.getClassLoader(source.getClassLoaderId());
        JmsBindingMetadata metadata = source.getMetadata();
        ResolvedObjects objects = this.resolveAdministeredObjects(source);
        ContainerConfiguration configuration = new ContainerConfiguration();
        try {
            ConnectionFactory connectionFactory = objects.getRequestFactory();
            Destination destination = objects.getRequestDestination();
            EventStream stream = connection.getEventStream();
            EventStreamListener listener = new EventStreamListener(sourceClassLoader, stream.getHeadHandler(), this.monitor);
            configuration.setDestinationType(metadata.getDestination().geType());
            configuration.setDestination(destination);
            configuration.setFactory(connectionFactory);
            configuration.setMessageListener(listener);
            configuration.setUri(serviceUri);
            configuration.setSessionType(source.getSessionType());
            this.populateConfiguration(configuration, metadata);
            if (this.containerManager.isRegistered(serviceUri)) {
                this.containerManager.unregister(serviceUri);
            }
            AdaptiveMessageContainer container = this.containerFactory.create(configuration);
            this.containerManager.register(container);
        }
        catch (JMSException e) {
            throw new ContainerException((Throwable)e);
        }
    }

    public void detach(JmsConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target) throws ContainerException {
        try {
            this.containerManager.unregister(source.getUri());
            this.resolver.release(source.getMetadata().getConnectionFactory());
        }
        catch (JMSException e) {
            throw new ContainerException((Throwable)e);
        }
    }

    private void populateConfiguration(ContainerConfiguration configuration, JmsBindingMetadata metadata) {
        CacheLevel cacheLevel = metadata.getCacheLevel();
        if (CacheLevel.CONNECTION == cacheLevel) {
            configuration.setCacheLevel(1);
        } else if (CacheLevel.ADMINISTERED_OBJECTS == cacheLevel) {
            configuration.setCacheLevel(2);
        } else {
            configuration.setCacheLevel(0);
        }
        configuration.setIdleLimit(metadata.getIdleLimit());
        configuration.setMaxMessagesToProcess(metadata.getMaxMessagesToProcess());
        configuration.setMaxReceivers(metadata.getMaxReceivers());
        configuration.setMinReceivers(metadata.getMinReceivers());
        configuration.setReceiveTimeout(metadata.getReceiveTimeout());
        configuration.setSubscriptionId(metadata.getSubscriptionId());
        configuration.setDurable(metadata.isDurable());
    }

    private ResolvedObjects resolveAdministeredObjects(JmsConnectionSourceDefinition source) throws ContainerException {
        JmsBindingMetadata metadata = source.getMetadata();
        ConnectionFactoryDefinition definition = metadata.getConnectionFactory();
        ConnectionFactory requestConnectionFactory = this.resolver.resolve(definition);
        DestinationDefinition requestDestinationDefinition = metadata.getDestination();
        Destination requestDestination = this.resolver.resolve(requestDestinationDefinition, requestConnectionFactory);
        return new ResolvedObjects(requestConnectionFactory, requestDestination);
    }

    private class ResolvedObjects {
        private ConnectionFactory requestFactory;
        private Destination requestDestination;

        private ResolvedObjects(ConnectionFactory requestFactory, Destination requestDestination) {
            this.requestFactory = requestFactory;
            this.requestDestination = requestDestination;
        }

        public ConnectionFactory getRequestFactory() {
            return this.requestFactory;
        }

        public Destination getRequestDestination() {
            return this.requestDestination;
        }
    }
}

